/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding.adapters;

import com.sun.kvem.beansbinding.adapters.BeanAdapterBase;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public class AbstractButtonAdapter
extends BeanAdapterBase {
    private static final String SELECTED_P = "selected";
    private final AbstractButton button;
    private boolean cachedSelected;
    private Handler handler;

    public AbstractButtonAdapter(AbstractButton abstractButton) {
        super(SELECTED_P);
        this.button = abstractButton;
    }

    public boolean isSelected() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.button.isSelected();
    }

    public void setSelected(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.button.setSelected(bl);
    }

    @Override
    protected void listeningStarted() {
        this.handler = new Handler();
        this.cachedSelected = this.isSelected();
        this.button.addItemListener(this.handler);
        this.button.addPropertyChangeListener("model", this.handler);
    }

    @Override
    protected void listeningStopped() {
        this.button.removeItemListener(this.handler);
        this.button.removePropertyChangeListener("model", this.handler);
        this.handler = null;
    }

    private class Handler
    implements ItemListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void buttonSelectedChanged() {
            boolean bl = AbstractButtonAdapter.this.cachedSelected;
            AbstractButtonAdapter.this.cachedSelected = AbstractButtonAdapter.this.isSelected();
            AbstractButtonAdapter.this.firePropertyChange(bl, AbstractButtonAdapter.this.cachedSelected);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.buttonSelectedChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.buttonSelectedChanged();
        }
    }
}

