/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding.adapters;

import com.sun.kvem.beansbinding.adapters.BeanAdapterBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class JSliderAdapter
extends BeanAdapterBase {
    public static final String PROPERTY_BASE = "value";
    public static final String IGNORE_ADJUSTING = "value_IGNORE_ADJUSTING";
    private JSlider slider;
    private Handler handler;
    private int cachedValue;

    public JSliderAdapter(JSlider jSlider, String string) {
        super(string);
        this.slider = jSlider;
    }

    public int getValue() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.slider.getValue();
    }

    public int getValue_IGNORE_ADJUSTING() {
        return this.getValue();
    }

    public void setValue(int n) {
        assert (SwingUtilities.isEventDispatchThread());
        this.slider.setValue(n);
    }

    public void setValue_IGNORE_ADJUSTING(int n) {
        this.setValue(n);
    }

    @Override
    protected void listeningStarted() {
        this.handler = new Handler();
        this.cachedValue = this.getValue();
        this.slider.addChangeListener(this.handler);
        this.slider.addPropertyChangeListener("model", this.handler);
    }

    @Override
    protected void listeningStopped() {
        this.slider.removeChangeListener(this.handler);
        this.slider.removePropertyChangeListener("model", this.handler);
        this.handler = null;
    }

    private class Handler
    implements ChangeListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void sliderValueChanged() {
            int n = JSliderAdapter.this.cachedValue;
            JSliderAdapter.this.cachedValue = JSliderAdapter.this.getValue();
            JSliderAdapter.this.firePropertyChange(n, JSliderAdapter.this.cachedValue);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (JSliderAdapter.this.property == JSliderAdapter.IGNORE_ADJUSTING && JSliderAdapter.this.slider.getValueIsAdjusting()) {
                return;
            }
            this.sliderValueChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.sliderValueChanged();
        }
    }
}

