/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor;

import com.sun.kvem.beans.IndexedEmbeddedPropertyChangeEvent;
import com.sun.kvem.sensor.api.Channel;
import com.sun.kvem.sensor.api.Sensor;
import com.sun.kvem.sensor.api.SensorProxy;
import com.sun.kvem.sensor.impl.ExtDataOutputStream;
import com.sun.kvem.sensor.model.Data;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SensorProxyServer {
    public static final String SENSORS_PROXY_PROPERTY = "sensorProxy";
    private static SensorProxyServer INSTANCE;
    private final List<SensorProxy> sensorRegistry = new ArrayList<SensorProxy>();
    private PropertyChangeListener propertyChangeForwarder = new PropertyChangeForwarder();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static SensorProxyServer getInstance() {
        return INSTANCE;
    }

    public SensorProxyServer() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Instance of SensorProxyServer already exists");
        }
        INSTANCE = this;
    }

    public static boolean initSensor(int n) {
        return SensorProxyServer.getInstance().getSensorProxy(n).init();
    }

    public static boolean finishSensor(int n) {
        return SensorProxyServer.getInstance().getSensorProxy(n).finish();
    }

    public static boolean isAvailable(int n) {
        return SensorProxyServer.getInstance().getSensorProxy(n).getSensorInfo().isAvailable();
    }

    public static byte[] measureData(int n, int n2) {
        SensorProxy sensorProxy = SensorProxyServer.getInstance().getSensorProxy(n);
        if (!sensorProxy.getSensorInfo().isAvailable()) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Data data = sensorProxy.measureData(n2);
        try {
            sensorProxy.getSensorDataWriter().writeData(byteArrayOutputStream, sensorProxy, data);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public static int sensorCount() {
        return SensorProxyServer.getInstance().getSensorCount();
    }

    public static byte[] getSensor(int n) {
        Sensor sensor = SensorProxyServer.getInstance().getSensorProxy(n).getSensorInfo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExtDataOutputStream extDataOutputStream = new ExtDataOutputStream(byteArrayOutputStream);
        try {
            extDataOutputStream.writeString(sensor.getDescription());
            extDataOutputStream.writeString(sensor.getModel());
            extDataOutputStream.writeString(sensor.getQuantity());
            extDataOutputStream.writeString(sensor.getContextType().toString());
            extDataOutputStream.writeInt(sensor.getConnType().getId());
            extDataOutputStream.writeBoolean(sensor.isAvailablePush());
            extDataOutputStream.writeBoolean(sensor.isConditionPush());
            extDataOutputStream.writeInt(sensor.getMaxBufSize());
            extDataOutputStream.writeInt(sensor.getChannels().length);
            extDataOutputStream.writeProperties(sensor.getProperties());
            extDataOutputStream.writeErrors(sensor.getErrors());
            extDataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public static byte[] getChannel(int n, int n2) {
        Channel channel = SensorProxyServer.getInstance().getSensorProxy(n).getSensorInfo().getChannels(n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExtDataOutputStream extDataOutputStream = new ExtDataOutputStream(byteArrayOutputStream);
        try {
            extDataOutputStream.writeString(channel.getName());
            extDataOutputStream.writeString(channel.getUnit());
            extDataOutputStream.writeInt(channel.getDataType().getId());
            extDataOutputStream.writeInt(channel.getAccuracy());
            extDataOutputStream.writeInt(channel.getScale());
            extDataOutputStream.writeInt(channel.getMeasurementRanges().length);
            extDataOutputStream.writeMeasurementRanges(channel.getMeasurementRanges());
            extDataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public void start() {
    }

    public SensorProxy[] getSensorProxy() {
        return this.sensorRegistry.toArray(new SensorProxy[this.sensorRegistry.size()]);
    }

    public int getSensorCount() {
        return this.sensorRegistry.size();
    }

    public SensorProxy getSensorProxy(int n) {
        return this.sensorRegistry.get(n);
    }

    public void addSensorProxy(SensorProxy sensorProxy) {
        sensorProxy.addPropertyChangeListener(this.propertyChangeForwarder);
        SensorProxy[] sensorProxyArray = this.getSensorProxy();
        this.sensorRegistry.add(sensorProxy);
        SensorProxy[] sensorProxyArray2 = this.getSensorProxy();
        this.pcs.firePropertyChange(SENSORS_PROXY_PROPERTY, sensorProxyArray, sensorProxyArray2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    class PropertyChangeForwarder
    implements PropertyChangeListener {
        PropertyChangeForwarder() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IndexedEmbeddedPropertyChangeEvent indexedEmbeddedPropertyChangeEvent = new IndexedEmbeddedPropertyChangeEvent((Object)SensorProxyServer.this, SensorProxyServer.SENSORS_PROXY_PROPERTY, SensorProxyServer.this.sensorRegistry.indexOf(propertyChangeEvent.getSource()), propertyChangeEvent);
            SensorProxyServer.this.pcs.firePropertyChange(indexedEmbeddedPropertyChangeEvent);
        }
    }
}

