/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor;

import com.sun.kvem.ExternalEventManager;
import com.sun.kvem.beans.IndexedEmbeddedPropertyChangeEvent;
import com.sun.kvem.environment.EventGenUI;
import com.sun.kvem.sensor.SensorProxyServer;
import com.sun.kvem.sensor.api.GuiSensorProxy;
import com.sun.kvem.sensor.api.SensorProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SensorsEventGenPanel
implements EventGenUI {
    private JFrame parent;
    private final JPanel gui = new JPanel();
    private JScrollPane sensorControlsScrollPane = new JScrollPane();
    private JTable sensorsTable;
    private JSplitPane splitPane;
    private String title;
    private String[] tableHeaders = new String[3];
    private SensorProxyServer sensorProxyServer;

    public void start() {
        this.gui.setLayout(new BorderLayout());
        this.sensorsTable = new JTable(new SensorsTableModel(this.sensorProxyServer));
        this.sensorsTable.setSelectionMode(0);
        this.sensorsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.sensorsTable.getColumnModel().getColumn(1).setPreferredWidth(500);
        this.sensorsTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.sensorsTable.setPreferredScrollableViewportSize(this.sensorsTable.getPreferredSize());
        JScrollPane jScrollPane = new JScrollPane(this.sensorsTable);
        this.splitPane = new JSplitPane(0);
        this.splitPane.add((Component)jScrollPane, "top");
        this.splitPane.add((Component)this.sensorControlsScrollPane, "bottom");
        Dimension dimension = new Dimension(0, 100);
        jScrollPane.setMinimumSize(dimension);
        this.sensorControlsScrollPane.setMinimumSize(dimension);
        this.gui.add((Component)this.splitPane, "Center");
        this.bindControllers();
        this.gui.validate();
        this.gui.repaint();
    }

    private void bindControllers() {
        this.sensorsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SensorProxy sensorProxy = SensorsEventGenPanel.this.sensorProxyServer.getSensorProxy(SensorsEventGenPanel.this.sensorsTable.getSelectedRow());
                    SensorsEventGenPanel.this.displaySensorControls(sensorProxy);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SensorsEventGenPanel.this.sensorsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        });
    }

    protected void displaySensorControls(SensorProxy sensorProxy) {
        assert (SwingUtilities.isEventDispatchThread());
        JComponent jComponent = sensorProxy instanceof GuiSensorProxy ? ((GuiSensorProxy)sensorProxy).getGuiControls() : new JLabel("No controls", 0);
        this.sensorControlsScrollPane.setViewportView(jComponent);
        this.splitPane.resetToPreferredSizes();
    }

    public String getEventData(String string) {
        return null;
    }

    public JPanel getGUI() {
        return this.gui;
    }

    public String getTitle() {
        return this.title;
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public void setExternalEventManager(ExternalEventManager externalEventManager) {
        externalEventManager.register((EventGenUI)this);
    }

    public void setSensorProxyServer(SensorProxyServer sensorProxyServer) {
        this.sensorProxyServer = sensorProxyServer;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTableHeader1(String string) {
        this.tableHeaders[0] = string;
    }

    public void setTableHeader2(String string) {
        this.tableHeaders[1] = string;
    }

    public void setTableHeader3(String string) {
        this.tableHeaders[2] = string;
    }

    class SensorsTableModel
    extends AbstractTableModel {
        private static final String AVAILABLE_PROPERTY = "available";
        private final SensorProxyServer sensorProxyServer;

        public SensorsTableModel(SensorProxyServer sensorProxyServer) {
            this.sensorProxyServer = sensorProxyServer;
            sensorProxyServer.addPropertyChangeListener("sensorProxy", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent instanceof IndexedEmbeddedPropertyChangeEvent) {
                        IndexedEmbeddedPropertyChangeEvent indexedEmbeddedPropertyChangeEvent = (IndexedEmbeddedPropertyChangeEvent)propertyChangeEvent;
                        int n = indexedEmbeddedPropertyChangeEvent.getIndex();
                        propertyChangeEvent = indexedEmbeddedPropertyChangeEvent.getEmbeddedEvent();
                        SensorsTableModel.this.fireTableRowsUpdated(n, n);
                    } else {
                        SensorsTableModel.this.fireTableDataChanged();
                    }
                }
            });
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.sensorProxyServer.getSensorProxy().length;
        }

        @Override
        public String getColumnName(int n) {
            return SensorsEventGenPanel.this.tableHeaders[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return this.isAvailabilityWritable(this.sensorProxyServer.getSensorProxy(n));
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2 && object instanceof Boolean) {
                SensorProxy sensorProxy = this.sensorProxyServer.getSensorProxy(n);
                boolean bl = (Boolean)object;
                this.trySetAvailability(sensorProxy, bl);
            }
        }

        private boolean isAvailabilityWritable(SensorProxy sensorProxy) {
            if (sensorProxy instanceof GuiSensorProxy) {
                return ((GuiSensorProxy)sensorProxy).isAvailableWritable();
            }
            return false;
        }

        private void trySetAvailability(SensorProxy sensorProxy, boolean bl) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(sensorProxy.getClass());
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    if (!AVAILABLE_PROPERTY.equals(propertyDescriptor.getName())) continue;
                    try {
                        propertyDescriptor.getWriteMethod().invoke((Object)sensorProxy, bl);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SensorProxy sensorProxy = this.sensorProxyServer.getSensorProxy(n);
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return sensorProxy.getSensorInfo().getURL();
                }
                case 2: {
                    return sensorProxy.getSensorInfo().isAvailable();
                }
            }
            assert (false);
            return null;
        }
    }
}

