/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.sensor.api.SensorDataWriter;
import com.sun.kvem.sensor.api.SensorProxy;
import com.sun.kvem.sensor.model.Data;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractSensorDataWriter
implements SensorDataWriter {
    @Override
    public final void writeData(ByteArrayOutputStream byteArrayOutputStream, SensorProxy sensorProxy, Data data) throws IOException {
        if (data == null) {
            throw new IOException("Data is null");
        }
        Object[] objectArray = data.getValues();
        int n = objectArray[0] instanceof Double ? 1 : (objectArray[0] instanceof Integer ? 2 : 4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(n);
        dataOutputStream.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Number number;
            dataOutputStream.writeBoolean(data.isValid(i));
            dataOutputStream.writeFloat(data.getUncertainty(i));
            if (n == 1) {
                number = (Double)objectArray[i];
                dataOutputStream.writeDouble((Double)number);
                continue;
            }
            if (n == 2) {
                number = (Integer)objectArray[i];
                dataOutputStream.writeInt((Integer)number);
                continue;
            }
            dataOutputStream.flush();
            this.writeObjectData(byteArrayOutputStream, objectArray[i]);
        }
        dataOutputStream.flush();
    }

    protected abstract void writeObjectData(ByteArrayOutputStream var1, Object var2);
}

