/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.beansbinding.Binding;
import com.sun.kvem.beansbinding.Property;
import com.sun.kvem.beansbinding.PropertyAdapter;
import com.sun.kvem.beansbinding.PropertyWrapper;
import com.sun.kvem.beansbinding.adapters.JSliderAdapter;
import com.sun.kvem.sensor.api.DataType;
import com.sun.kvem.sensor.api.MeasurementRange;
import com.sun.kvem.sensor.model.ChannelModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;

class ChannelControllerPanel
extends JPanel {
    JPanel captionPanel = new JPanel();
    JLabel channelNameLabel = new JLabel();
    JSlider valueSlider = new JSlider(0);
    NumberFormatter valueNumberFormatter = new NumberFormatter();
    JFormattedTextField valueTextField = new JFormattedTextField(this.valueNumberFormatter);
    JLabel channelUnitLabel = new JLabel();
    private Binding<BigDecimal, Integer> valueSliderBinding;
    private Binding<BigDecimal, BigDecimal> valueTextFieldBinding;

    public ChannelControllerPanel() {
        this.valueNumberFormatter.setValueClass(BigDecimal.class);
        this.setLayout(new BorderLayout());
        this.captionPanel.setLayout(new GridBagLayout());
        this.valueSlider.setPaintLabels(true);
        this.valueSlider.setPaintTicks(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 8.0;
        this.captionPanel.add((Component)this.valueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.valueTextField.setPreferredSize(new Dimension(this.valueTextField.getFontMetrics(this.valueTextField.getFont()).stringWidth("_-0.00_"), this.valueTextField.getPreferredSize().height));
        this.captionPanel.add((Component)this.valueTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.captionPanel.add((Component)this.channelUnitLabel, gridBagConstraints);
        this.add((Component)this.captionPanel, "North");
    }

    public void bind(ChannelModel channelModel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.captionPanel.setBorder(BorderFactory.createTitledBorder(channelModel.getName()));
        this.channelNameLabel.setText(channelModel.getName());
        this.channelUnitLabel.setText(channelModel.getUnit());
        MeasurementRange measurementRange = channelModel.getMeasurementRanges()[0];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
        arrayList.add(measurementRange.getLargest().scale());
        arrayList.add(measurementRange.getSmallest().scale());
        arrayList.add(measurementRange.getResolution().scale());
        arrayList.add(channelModel.getBigDecimalValue().scale());
        int n = (Integer)Collections.max(arrayList);
        int n2 = measurementRange.getLargest().movePointRight(n).intValue();
        int n3 = measurementRange.getSmallest().movePointRight(n).intValue();
        int n4 = measurementRange.getResolution().movePointRight(n).intValue();
        int n5 = channelModel.getBigDecimalValue().movePointRight(n).intValue();
        this.valueSlider.getModel().setRangeProperties(n5, 0, n3, n2, false);
        this.valueSlider.setLabelTable(new LabelHashTable(n3, n2, (n2 - n3) / 10, n));
        this.valueSlider.setMajorTickSpacing((n2 - n3) / 2);
        this.valueSlider.setMinorTickSpacing((n2 - n3) / 10);
        this.valueSlider.setPreferredSize(new Dimension(11 * this.valueSlider.getFontMetrics(this.valueSlider.getFont()).stringWidth("_-0.00_"), this.valueSlider.getPreferredSize().height));
        if (channelModel.getDataType() == DataType.INTEGER) {
            this.valueNumberFormatter.setFormat(DecimalFormat.getIntegerInstance());
        } else {
            this.valueNumberFormatter.setFormat(DecimalFormat.getNumberInstance());
        }
        this.valueNumberFormatter.setMinimum(measurementRange.getSmallest());
        this.valueNumberFormatter.setMaximum(measurementRange.getLargest());
        PropertyAdapter<BigDecimal> propertyAdapter = channelModel.getValueProperty();
        Property<BigDecimal> property = null;
        property = channelModel.getDataType() == DataType.INTEGER ? propertyAdapter : new PropertyTranslate(n, propertyAdapter);
        this.valueSliderBinding = new Binding(Binding.UpdateStrategy.READ_WRITE, property, new PropertyWrapper(new JSliderAdapter(this.valueSlider, "value"), "value"));
        this.valueTextFieldBinding = new Binding(Binding.UpdateStrategy.READ_WRITE, propertyAdapter, new PropertyWrapper(this.valueTextField, "value"));
        this.valueSliderBinding.bind();
        this.valueTextFieldBinding.bind();
    }

    public void unbind() {
        assert (SwingUtilities.isEventDispatchThread());
        this.valueSliderBinding.unbind();
        this.valueTextFieldBinding.unbind();
        this.valueSliderBinding = null;
        this.valueTextFieldBinding = null;
    }

    private class PropertyTranslate
    implements Property<BigDecimal> {
        private final int scale;
        private final PropertyAdapter<BigDecimal> channelValueProperty;

        public PropertyTranslate(int n, PropertyAdapter<BigDecimal> propertyAdapter) {
            this.scale = n;
            this.channelValueProperty = propertyAdapter;
        }

        @Override
        public BigDecimal getValue() {
            return this.channelValueProperty.getValue().movePointRight(this.scale);
        }

        @Override
        public void setValue(BigDecimal bigDecimal) {
            this.channelValueProperty.setValue(bigDecimal.movePointLeft(this.scale));
        }

        @Override
        public Class<?> getWriteType() {
            return this.channelValueProperty.getWriteType();
        }

        @Override
        public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
            this.channelValueProperty.addValueChangeListener(new ListenerTranslate(propertyChangeListener));
        }

        @Override
        public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
            this.channelValueProperty.removeValueChangeListener(new ListenerTranslate(propertyChangeListener));
        }

        class ListenerTranslate
        implements PropertyChangeListener {
            private PropertyChangeListener listener;

            public ListenerTranslate(PropertyChangeListener propertyChangeListener) {
                this.listener = propertyChangeListener;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.listener.propertyChange(new PropertyChangeEvent(PropertyTranslate.this, propertyChangeEvent.getPropertyName(), ((BigDecimal)propertyChangeEvent.getOldValue()).movePointRight(PropertyTranslate.this.scale), ((BigDecimal)propertyChangeEvent.getNewValue()).movePointRight(PropertyTranslate.this.scale)));
            }
        }
    }

    private class LabelHashTable
    extends Hashtable {
        LabelHashTable(int n, int n2, int n3, int n4) {
            for (int i = n; i <= n2; i += n3) {
                this.put(new Integer(i), new JLabel(new BigDecimal(i).movePointLeft(n4).toString()));
            }
        }
    }
}

