/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.sensor.api.Channel;
import com.sun.kvem.sensor.api.DataType;
import com.sun.kvem.sensor.api.MeasurementRange;
import com.sun.kvem.sensor.model.ChannelModel;

public class DefaultGuiChannelProxy {
    private Channel channel = new ChannelModel();
    private String value;
    private String measurementSmallest;
    private String measurementLargest;
    private String measurementResolution;

    public Channel getChannelInfo() {
        return this.channel;
    }

    public void create() {
        switch (this.channel.getDataType()) {
            case DOUBLE: {
                this.channel.setValue(Double.parseDouble(this.value));
                this.channel.setMeasurementRanges(new MeasurementRange[]{new MeasurementRange(Double.parseDouble(this.measurementSmallest), Double.parseDouble(this.measurementLargest), Double.parseDouble(this.measurementResolution))});
                break;
            }
            case INTEGER: {
                this.channel.setValue(Integer.parseInt(this.value));
                this.channel.setMeasurementRanges(new MeasurementRange[]{new MeasurementRange(Integer.parseInt(this.measurementSmallest), Integer.parseInt(this.measurementLargest), Integer.parseInt(this.measurementResolution))});
            }
        }
    }

    public void setName(String string) {
        this.channel.setName(string);
    }

    public void setUnit(String string) {
        this.channel.setUnit(string);
    }

    public void setInitValue(String string) {
        this.value = string;
    }

    public void setDataType(int n) {
        this.channel.setDataType(DataType.intToType(n));
    }

    public void setAccuracy(int n) {
        this.channel.setAccuracy(n);
    }

    public void setSmallest(String string) {
        this.measurementSmallest = string;
    }

    public void setLargest(String string) {
        this.measurementLargest = string;
    }

    public void setResolution(String string) {
        this.measurementResolution = string;
    }
}

