/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.beansbinding.Binding;
import com.sun.kvem.beansbinding.PropertyWrapper;
import com.sun.kvem.beansbinding.adapters.JSliderAdapter;
import com.sun.kvem.beansbinding.adapters.JTextComponentAdapter;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.sensor.model.SensorModel;
import com.sun.kvem.sensor.util.ScriptFailureListener;
import com.sun.kvem.sensor.util.ScriptLoader;
import com.sun.kvem.sensor.util.ScriptPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

class ScriptPlayerPanel
extends JPanel {
    private final String ERROR_MSG;
    private JPanel insidePanel = new JPanel();
    private JLabel fileNameLabel = new JLabel();
    private JTextField fileNameTextField = new JTextField();
    private JButton browseButton = new JButton();
    private JSlider progressSlider = new JSlider();
    private JButton startButton = new JButton();
    private JButton pauseButton = new JButton();
    private JButton stopButton = new JButton();
    private Controller controller;

    public ScriptPlayerPanel(Map<String, String> map) {
        this.setupComponents(map);
        this.layoutComponents();
        this.ERROR_MSG = map.get("failure");
    }

    private void setupComponents(Map<String, String> map) {
        this.startButton.setText(map.get("start"));
        this.pauseButton.setText(map.get("pause"));
        this.stopButton.setText(map.get("stop"));
        this.fileNameLabel.setText(map.get("fileName"));
        this.browseButton.setText(map.get("browse"));
        this.progressSlider.setValue(0);
        this.progressSlider.setEnabled(false);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.insidePanel.setLayout(new GridBagLayout());
        this.add((Component)this.insidePanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        this.insidePanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.insidePanel.add((Component)this.fileNameTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.insidePanel.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.insidePanel.add((Component)this.progressSlider, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPlayerPanel.this.controller.performStartAction();
            }
        });
        this.insidePanel.add((Component)this.startButton, gridBagConstraints);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPlayerPanel.this.controller.performPauseAction();
            }
        });
        this.insidePanel.add((Component)this.pauseButton, gridBagConstraints);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPlayerPanel.this.controller.performStopAction();
            }
        });
        this.insidePanel.add((Component)this.stopButton, gridBagConstraints);
        this.fileNameTextField.setPreferredSize(this.fileNameTextField.getMinimumSize());
    }

    public void bind(SensorModel sensorModel) {
        this.controller = new Controller(new ScriptLoader(sensorModel));
        this.controller.setFileBrowseButon(this.browseButton);
        this.controller.setFileNameTextField(this.fileNameTextField);
        this.controller.setTimeSlider(this.progressSlider);
        this.insidePanel.invalidate();
        this.invalidate();
    }

    class Controller
    implements ScriptFailureListener,
    PropertyChangeListener {
        private final ScriptLoader scriptLoader;
        private State state;
        private ScriptPlayer scriptPlayer;
        private JTextComponentAdapter textComponentAdapter;
        private JTextComponent fileNameTextField;
        private JButton browseButton;
        private JSlider progressSlider;
        private Binding<Integer, Integer> timeSliderBinding;

        public Controller(ScriptLoader scriptLoader) {
            this.scriptLoader = scriptLoader;
        }

        public void setTimeSlider(JSlider jSlider) {
            this.progressSlider = jSlider;
        }

        public void setFileBrowseButon(JButton jButton) {
            this.browseButton = jButton;
            this.browseButton.addActionListener(new SelectFileActionListener());
        }

        public synchronized void setFileNameTextField(JTextComponent jTextComponent) {
            if (this.fileNameTextField == jTextComponent) {
                return;
            }
            if (this.textComponentAdapter != null) {
                this.textComponentAdapter.removePropertyChangeListener(this);
            }
            this.fileNameTextField = jTextComponent;
            if ("".equals(jTextComponent.getText().trim())) {
                this.setState(State.NO_SCRIPT_NAME);
            } else {
                this.setState(State.READY_TO_PLAY);
            }
            this.textComponentAdapter = new JTextComponentAdapter(jTextComponent, "text");
            this.textComponentAdapter.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Controller.this.updateControllerState();
                }
            };
            if (this.scriptPlayer == propertyChangeEvent.getSource() || this.textComponentAdapter == propertyChangeEvent.getSource()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }

        private synchronized void updateControllerState() {
            if ("".equals(this.textComponentAdapter.getText().trim())) {
                this.setState(State.NO_SCRIPT_NAME);
            } else {
                this.setState(State.READY_TO_PLAY);
            }
            if (this.scriptPlayer != null) {
                if (this.scriptPlayer.isFinished()) {
                    this.setScriptPlayer(null);
                    this.setState(State.READY_TO_PLAY);
                } else if (this.scriptPlayer.isPlaying()) {
                    this.setState(State.PLAYING);
                } else if (this.scriptPlayer.isPaused()) {
                    this.setState(State.PAUSED);
                }
            }
        }

        private synchronized void setState(State state) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.state == state) {
                return;
            }
            this.state = state;
            switch (state) {
                case PREPARE_SCRIPT: {
                    ScriptPlayerPanel.this.startButton.setEnabled(false);
                    ScriptPlayerPanel.this.pauseButton.setEnabled(false);
                    ScriptPlayerPanel.this.stopButton.setEnabled(false);
                    this.fileNameTextField.setEnabled(false);
                    this.browseButton.setEnabled(false);
                    break;
                }
                case NO_SCRIPT_NAME: {
                    ScriptPlayerPanel.this.startButton.setEnabled(false);
                    ScriptPlayerPanel.this.pauseButton.setEnabled(false);
                    ScriptPlayerPanel.this.stopButton.setEnabled(false);
                    this.fileNameTextField.setEnabled(true);
                    this.browseButton.setEnabled(true);
                    break;
                }
                case READY_TO_PLAY: {
                    ScriptPlayerPanel.this.startButton.setEnabled(true);
                    ScriptPlayerPanel.this.pauseButton.setEnabled(false);
                    ScriptPlayerPanel.this.stopButton.setEnabled(false);
                    this.fileNameTextField.setEnabled(true);
                    this.browseButton.setEnabled(true);
                    break;
                }
                case PAUSED: {
                    ScriptPlayerPanel.this.startButton.setEnabled(true);
                    ScriptPlayerPanel.this.pauseButton.setEnabled(false);
                    ScriptPlayerPanel.this.stopButton.setEnabled(true);
                    this.fileNameTextField.setEnabled(false);
                    this.browseButton.setEnabled(false);
                    break;
                }
                case PLAYING: {
                    ScriptPlayerPanel.this.startButton.setEnabled(false);
                    ScriptPlayerPanel.this.pauseButton.setEnabled(true);
                    ScriptPlayerPanel.this.stopButton.setEnabled(true);
                    this.fileNameTextField.setEnabled(false);
                    this.browseButton.setEnabled(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public void failure(Throwable throwable) {
            this.updateControllerState();
        }

        private void setScriptPlayer(ScriptPlayer scriptPlayer) {
            if (this.scriptPlayer != scriptPlayer && this.scriptPlayer != null) {
                this.scriptPlayer.removeFailureListener(this);
                this.scriptPlayer.removePropertyChangeListener(this);
            }
            this.scriptPlayer = scriptPlayer;
            if (this.scriptPlayer != null) {
                this.scriptPlayer.addFailureListener(this);
                this.scriptPlayer.addPropertyChangeListener(this);
            }
        }

        synchronized void performStartAction() {
            if (this.state == State.READY_TO_PLAY) {
                assert (this.scriptPlayer == null);
                this.setState(State.PREPARE_SCRIPT);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final ScriptLoader.Script script = Controller.this.scriptLoader.loadScript(Controller.this.fileNameTextField.getText());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (script != null) {
                                    Controller.this.bindTimeSlider(script);
                                    Controller.this.setScriptPlayer(new ScriptPlayer(script));
                                    Controller.this.scriptPlayer.start();
                                    Controller.this.setState(State.PLAYING);
                                } else {
                                    JOptionPane.showMessageDialog(null, ScriptPlayerPanel.this.ERROR_MSG, "Error", 0);
                                    Controller.this.setState(State.READY_TO_PLAY);
                                }
                            }
                        });
                    }
                }).start();
            } else if (this.state == State.PAUSED) {
                if (this.scriptPlayer != null) {
                    this.scriptPlayer.start();
                }
            } else assert (false);
        }

        private void bindTimeSlider(ScriptLoader.Script script) {
            if (this.timeSliderBinding != null) {
                this.timeSliderBinding.unbind();
            }
            this.timeSliderBinding = new Binding(Binding.UpdateStrategy.READ, script.getCurrentProgressProperty(), new PropertyWrapper(new JSliderAdapter(this.progressSlider, "value"), "value"));
            this.timeSliderBinding.bind();
        }

        public synchronized void performPauseAction() {
            assert (this.state == State.PLAYING);
            if (this.scriptPlayer != null) {
                this.scriptPlayer.tryStop();
            }
            this.updateControllerState();
        }

        public synchronized void performStopAction() {
            assert (this.state == State.PLAYING || this.state == State.PAUSED);
            if (this.scriptPlayer != null) {
                this.scriptPlayer.tryStop();
            }
            this.setScriptPlayer(null);
            this.setState(State.READY_TO_PLAY);
        }

        class SelectFileActionListener
        implements ActionListener {
            SelectFileActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(ToolkitDirs.APPS);
                jFileChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "always");
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Controller.this.fileNameTextField.setText(file.getAbsolutePath());
                }
            }
        }
    }

    private static enum State {
        NO_SCRIPT_NAME,
        READY_TO_PLAY,
        PREPARE_SCRIPT,
        PLAYING,
        PAUSED;

    }
}

