/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.util;

import com.sun.kvem.beansbinding.Property;
import com.sun.kvem.beansbinding.PropertyAdapter;
import com.sun.kvem.sensor.api.Sensor;
import com.sun.kvem.sensor.model.ChannelModel;
import com.sun.kvem.sensor.model.SensorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptLoader {
    private static final Logger logger = Logger.getLogger(ScriptLoader.class);
    private final SensorModel sensor;

    public ScriptLoader(SensorModel sensorModel) {
        this.sensor = sensorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script loadScript(String string) {
        Script script = new Script();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(fileInputStream), (DefaultHandler)new SaxHandler(script));
            Script script2 = script;
            return script2;
        }
        catch (Exception exception) {
            logger.error((Object)"Cannot load script", (Throwable)exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)"Cannot close input stream", (Throwable)iOException);
                }
            }
        }
        return null;
    }

    private static class SetChannelValue
    implements Runnable {
        private final ChannelModel channel;
        private final BigDecimal value;

        public SetChannelValue(ChannelModel channelModel, BigDecimal bigDecimal) {
            this.channel = channelModel;
            this.value = bigDecimal;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.channel.getValueProperty().setValue(this.value);
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    private static class SetSensorAvailable
    implements Runnable {
        private final Sensor sensor;
        private final boolean active;

        public SetSensorAvailable(Sensor sensor, boolean bl) {
            this.sensor = sensor;
            this.active = bl;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.sensor.setAvailable(this.active);
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    private static class Delay
    implements Runnable {
        private final long delay;

        public Delay(long l) {
            this.delay = l;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Script
    implements Iterable<Runnable> {
        private long currentTime;
        private long duration;
        private int currentProgress;
        private Property<Integer> currentProgressProperty = new PropertyAdapter<Integer>(this, "currentProgress");
        private List<Runnable> actions = new ArrayList<Runnable>();

        public Property<Integer> getCurrentProgressProperty() {
            return this.currentProgressProperty;
        }

        public int getCurrentProgress() {
            return this.currentProgress;
        }

        public void setCurrentProgress(int n) {
            this.currentProgress = n;
        }

        public long getDuration() {
            return this.duration;
        }

        public boolean add(Delay delay) {
            this.duration += delay.delay;
            return this.actions.add(delay);
        }

        public boolean add(Runnable runnable) {
            return this.actions.add(runnable);
        }

        @Override
        public Iterator<Runnable> iterator() {
            this.currentTime = 0L;
            return new I(this.actions.iterator());
        }

        private class I
        implements Iterator<Runnable> {
            private final Iterator<Runnable> iterator;

            public I(Iterator<Runnable> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Runnable next() {
                Runnable runnable = this.iterator.next();
                if (runnable instanceof Delay) {
                    Script.this.currentTime += ((Delay)runnable).delay;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Script.this.currentProgressProperty.setValue((int)((double)Script.this.currentTime / (double)Script.this.duration * 100.0));
                        }
                    });
                }
                return runnable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class SaxHandler
    extends DefaultHandler {
        private final Script script;
        private long duration;
        private int channelId;

        public SaxHandler(Script script) {
            this.script = script;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            if ("value".equals(string3)) {
                long l = this.getLongValue(attributes, "time", 0L);
                this.duration += l;
                this.script.add(new Delay(l));
            } else if ("channel".equals(string3)) {
                this.channelId = (int)this.getLongValue(attributes, "id", 0L);
                double d = this.getDoubleValue(attributes, "value", 0.0);
                this.script.add(new SetChannelValue((ChannelModel)ScriptLoader.this.sensor.getChannels(this.channelId), BigDecimal.valueOf(d)));
            } else if ("sensor".equals(string3) && (string4 = this.getValue(attributes, "active", null)) != null) {
                this.script.add(new SetSensorAvailable(ScriptLoader.this.sensor, Boolean.parseBoolean(string4)));
            }
        }

        String getValue(Attributes attributes, String string, String string2) {
            String string3 = attributes.getValue(string);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }

        long getLongValue(Attributes attributes, String string, long l) {
            String string2 = this.getValue(attributes, string, null);
            if (string2 == null) {
                return l;
            }
            return Long.parseLong(string2);
        }

        double getDoubleValue(Attributes attributes, String string, double d) {
            String string2 = this.getValue(attributes, string, null);
            if (string2 == null) {
                return d;
            }
            return Double.parseDouble(string2);
        }
    }
}

