/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.util;

import com.sun.kvem.sensor.util.ScriptFailureListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ScriptPlayer {
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_FINISHED = "finished";
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PLAYING = 1;
    private int state = 0;
    private boolean finished;
    private Thread scriptPlayerThread;
    private final Iterator<? extends Runnable> actionsIterator;
    private final ExecutorService actionsExecutor;
    private final List<ScriptFailureListener> failureListeners;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ScriptPlayer(Iterable<? extends Runnable> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        this.actionsIterator = iterable.iterator();
        this.actionsExecutor = Executors.newSingleThreadExecutor();
        this.failureListeners = new ArrayList<ScriptFailureListener>();
    }

    public synchronized int getState() {
        return this.state;
    }

    private void setState(int n) {
        int n2 = this.state;
        if (n2 == n) {
            return;
        }
        this.state = n;
        this.pcs.firePropertyChange(PROPERTY_STATE, n2, n);
    }

    public synchronized void start() {
        if (1 == this.getState()) {
            throw new IllegalStateException("Script is already started");
        }
        if (!this.actionsIterator.hasNext()) {
            throw new IllegalStateException("Script is already finished");
        }
        if (this.scriptPlayerThread == null) {
            this.scriptPlayerThread = new Thread(new ScriptPlayerRunnable());
            this.scriptPlayerThread.start();
        }
        this.setState(1);
        this.notify();
    }

    public synchronized void stop() {
        if (0 == this.getState()) {
            throw new IllegalStateException("Script is already stopped");
        }
        this.uncheckedStop();
    }

    public synchronized boolean tryStop() {
        if (0 == this.getState()) {
            return false;
        }
        this.uncheckedStop();
        return true;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized boolean isPlaying() {
        return 1 == this.getState();
    }

    public synchronized boolean isPaused() {
        return !this.isFinished() && !this.isPlaying();
    }

    private void setFinished() {
        if (!this.finished) {
            this.finished = true;
            this.pcs.firePropertyChange(PROPERTY_FINISHED, false, true);
        }
    }

    private void uncheckedStop() {
        this.setState(0);
        if (!this.actionsIterator.hasNext()) {
            this.setFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailureListener(ScriptFailureListener scriptFailureListener) {
        List<ScriptFailureListener> list = this.failureListeners;
        synchronized (list) {
            this.failureListeners.add(scriptFailureListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFailureListener(ScriptFailureListener scriptFailureListener) {
        List<ScriptFailureListener> list = this.failureListeners;
        synchronized (list) {
            int n = this.failureListeners.lastIndexOf(scriptFailureListener);
            if (n != -1) {
                this.failureListeners.remove(n);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFailureOccured(Throwable throwable) {
        List<ScriptFailureListener> list;
        List<ScriptFailureListener> list2 = this.failureListeners;
        synchronized (list2) {
            list = Collections.unmodifiableList(this.failureListeners);
        }
        for (ScriptFailureListener scriptFailureListener : list) {
            scriptFailureListener.failure(throwable);
        }
    }

    private class ScriptPlayerRunnable
    implements Runnable {
        private ScriptPlayerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                block19: while (true) {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Object object = null;
                            ScriptPlayer scriptPlayer = ScriptPlayer.this;
                            synchronized (scriptPlayer) {
                                while (0 == ScriptPlayer.this.getState()) {
                                    ScriptPlayer.this.wait();
                                }
                                if (ScriptPlayer.this.actionsIterator.hasNext()) {
                                    object = (Runnable)ScriptPlayer.this.actionsIterator.next();
                                } else {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            if (object == null) continue;
                            try {
                                ScriptPlayer.this.actionsExecutor.submit((Runnable)object).get();
                                continue block19;
                            }
                            catch (ExecutionException executionException) {
                                Thread.currentThread().interrupt();
                                ScriptPlayer.this.fireFailureOccured(executionException.getCause());
                            }
                        }
                        break block24;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break block24;
                    }
                }
                finally {
                    ScriptPlayer scriptPlayer = ScriptPlayer.this;
                    synchronized (scriptPlayer) {
                        ScriptPlayer.this.uncheckedStop();
                    }
                }
            }
        }
    }
}

