/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.cldcdevice;

import com.sun.jme.services.productdesc.ProductInstanceId;
import com.sun.jme.toolkit.deviceadapter.cldcdevice.CldcProductParams;
import com.sun.jme.toolkit.deviceadapter.genericdevice.DeviceConnection;
import com.sun.jme.toolkit.deviceadapter.genericdevice.ProductParams;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.devicedetection.odt.OdtProductAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import kdp.KDP;

public class CldcDeviceConnection
extends DeviceConnection {
    private KDP kdp;
    private boolean kdpStarted;
    private int localJdwpPort;

    public CldcDeviceConnection(int n, ProductInstanceId productInstanceId, OdtProductAddress odtProductAddress, ProductParams productParams, String string) {
        super(n, productInstanceId, odtProductAddress, productParams);
        CldcProductParams cldcProductParams = (CldcProductParams)productParams;
        String string2 = cldcProductParams.getRuntimeClasses().getAbsolutePath();
        this.kdp = new KDP();
        this.kdp.setWorkdir(string);
        this.kdp.setKVMClasspath(string2);
    }

    private int getFreePortNumber() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int n = serverSocket.getLocalPort();
        serverSocket.close();
        return n;
    }

    protected void connectDebugger(InetAddress inetAddress, int n) throws Exception {
        this.localJdwpPort = this.getFreePortNumber();
        DeviceIpAddress deviceIpAddress = (DeviceIpAddress)this.getProductAddress().getDeviceAddress();
        this.kdp.setKvmHost(deviceIpAddress.getDeviceAddress());
        this.kdp.setJdwpPort(this.localJdwpPort);
        this.kdp.setKdwpPort(n);
        this.kdp.start();
        this.kdpStarted = true;
    }

    public KDP getDebugProxy() {
        return this.kdp;
    }

    public int getJdwpPortNumber() {
        return this.localJdwpPort;
    }

    protected void cleanup() {
        if (this.kdpStarted) {
            try {
                this.kdp.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.cleanup();
    }
}

