/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.appmanager.AppManagerException;
import com.sun.jme.toolkit.device.appmanager.api.AppManager;
import com.sun.jme.toolkit.ueiproxy.AppManagerHelper;
import com.sun.jme.toolkit.ueiproxy.CommandHandler;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerManager;
import com.sun.jme.toolkit.ueiproxy.RunOptions;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class JamHandler
implements CommandHandler {
    private static final String COMMAND = "-Xjam";
    private static final String FORCE_COMMAND = "-Xjam:force";
    private static final Logger logger = Logger.getLogger(JamHandler.class);
    private boolean otaForceInstall;
    private DeviceControllerManager deviceControllerManager;
    private AppManagerHelper appManagerHelper;
    private String command;

    public void setDeviceControllerManager(DeviceControllerManager deviceControllerManager) {
        this.deviceControllerManager = deviceControllerManager;
    }

    public void setAppManagerHelper(AppManagerHelper appManagerHelper) {
        this.appManagerHelper = appManagerHelper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(String string, String[] stringArray, String string2, RunOptions runOptions) throws UeiProxyException {
        if (this.command == null) {
            logger.error((Object)"No UEI command given.");
            throw new IllegalArgumentException("No UEI command given.");
        }
        if (this.command.length() > COMMAND.length()) {
            boolean bl;
            String string3;
            String string4;
            Object[] objectArray = new String[]{"list", "storageNames"};
            Object[] objectArray2 = new String[]{"install", "remove", "run", "transient"};
            if (this.command.charAt(5) != ':') throw new IllegalArgumentException("Unknown option: " + this.command);
            int n = this.command.indexOf("=");
            if (n == -1) {
                string4 = this.command.substring("-Xjam:".length());
                string3 = null;
            } else {
                string4 = this.command.substring("-Xjam:".length(), n);
                string3 = this.command.substring(n + 1);
            }
            if (string3 == null && string4.equals("force")) {
                this.otaForceInstall = true;
                return;
            }
            boolean bl2 = Arrays.binarySearch(objectArray2, string4) >= 0;
            boolean bl3 = bl = !bl2 && Arrays.binarySearch(objectArray, string4) >= 0;
            if (!bl && !bl2) {
                throw new IllegalArgumentException("\"" + string4 + "\"" + " is not a valid option for" + " -Xjam");
            }
            if (string3 == null || string3.length() == 0) {
                if (bl2) {
                    throw new IllegalArgumentException("You must supply a parameter for \"" + string4 + "\" command!");
                }
                this.processNoParamCommand(string4, string, stringArray);
                return;
            } else {
                this.processSingleParamCommand(string4, string3, string, stringArray, string2, runOptions);
            }
            return;
        } else {
            this.deviceControllerManager.getOrCreateDeviceController(string, stringArray);
        }
    }

    public String getCommand() {
        logger.trace((Object)"getCommand() -->");
        logger.trace((Object)"<-- getCommand() = -Xjam");
        return COMMAND;
    }

    public String getCommandDescription() {
        logger.trace((Object)"getCommandDescription() -->");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-Xjam[:install=<JAD file url> | force | list | storageNames |\n");
        stringBuffer.append("       run=[<storage name> | <storage number>] |\n");
        stringBuffer.append("       remove=[<storage name> | <storage number> | all]]\n");
        stringBuffer.append("                   Java Application Manager and support\n");
        stringBuffer.append("                   for Over The Air provisioning (OTA)");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("<-- getCommandDescription() = " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public boolean requiresDeviceName() {
        return true;
    }

    public boolean addSupportedCommand(String string) {
        if (string.startsWith(COMMAND)) {
            this.otaForceInstall = string.equals(FORCE_COMMAND);
            if (!this.otaForceInstall) {
                this.command = string;
            }
            return true;
        }
        return false;
    }

    private void processNoParamCommand(String string, String string2, String[] stringArray) throws UeiProxyException {
        DeviceController deviceController = this.deviceControllerManager.getOrCreateDeviceController(string2, stringArray);
        AppManager appManager = (AppManager)deviceController.getObjectFromDevice(AppManager.class, "AppManager");
        try {
            if (string.equals("storageNames")) {
                String[] stringArray2 = appManager.getStorageNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                }
            } else if (string.equals("list")) {
                String[] stringArray3 = appManager.getInstalledAppList();
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println(stringArray3[i]);
                }
            }
        }
        catch (AppManagerException appManagerException) {
            throw new UeiProxyException("Failed to execute \"" + string + "\"" + " command!", (Throwable)appManagerException);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to execute \"" + string + "\"" + " command!", (Throwable)runtimeException);
        }
    }

    private void processSingleParamCommand(String string, String string2, String string3, String[] stringArray, String string4, RunOptions runOptions) throws UeiProxyException {
        DeviceController deviceController = this.deviceControllerManager.getOrCreateDeviceController(string3, stringArray);
        AppManager appManager = (AppManager)deviceController.getObjectFromDevice(AppManager.class, "AppManager");
        if (string.equals("transient") || string.equals("run")) {
            int n = string2.indexOf(",");
            String string5 = null;
            if (n != -1) {
                string5 = string2.substring(n + 1).trim();
                if (string5.length() == 0) {
                    string5 = null;
                }
                string2 = string2.substring(0, n);
            }
            if (string.equals("run")) {
                this.appManagerHelper.runMIDletSuite(deviceController, appManager, string2, string5, runOptions);
            } else {
                this.appManagerHelper.executeMIDletSuite(deviceController, appManager, string2, true, string4, runOptions);
            }
        } else if (string.equals("install")) {
            int n = this.appManagerHelper.installMIDletSuite(deviceController, appManager, string2, this.otaForceInstall);
            if (n > 0) {
                System.out.println("The suite was succesfully installed, ID: " + n);
            }
        } else if (string.equals("remove")) {
            this.appManagerHelper.removeMIDletSuite(appManager, string2);
        }
    }
}

