/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.radiogram;

import com.sun.spot.io.j2me.radiogram.RadiogramConnImpl;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.TimeoutException;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.util.IEEEAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Datagram;

public class Radiogram
implements Datagram {
    public static final int MAX_LENGTH = 1260;
    private byte[] payload;
    private int payloadIndex;
    private int endOfDataIndex;
    private DataInputStream dis;
    private DataOutputStream dos;
    private long address;
    private RadiogramConnImpl connection;
    private LowPanHeaderInfo headerInfo;
    private long timestamp;

    public Radiogram(int size, RadiogramConnImpl connection) {
        this.connection = connection;
        this.reset();
        this.setRadioPacket(size);
        if (connection.isPointToPoint()) {
            this.address = connection.getMacAddress();
        } else if (connection.isBroadcast()) {
            this.address = -1L;
        }
        this.dis = new DataInputStream(new RadiogramInputStream());
        this.dos = new DataOutputStream(new RadiogramOutputStream());
    }

    public Radiogram(int size, RadiogramConnImpl connection, String addr) {
        this(size, connection);
        this.setAddress(addr);
    }

    public String getAddress() {
        return new IEEEAddress(this.address).asDottedHex();
    }

    public long getAddressAsLong() {
        return this.address;
    }

    public byte[] getData() {
        byte[] buffer = new byte[this.getLength()];
        System.arraycopy(this.payload, 1, buffer, 0, buffer.length);
        return buffer;
    }

    public int getLength() {
        return this.endOfDataIndex - 1;
    }

    public int getOffset() {
        return 0;
    }

    public void setAddress(String addr) {
        if (!this.connection.isServer()) {
            throw new IllegalStateException("Cannot set the address of a radiogram on a non-server connection");
        }
        this.address = new IEEEAddress(addr).asLong();
    }

    public void setAddress(Datagram reference) {
        if (!this.connection.isServer()) {
            throw new IllegalStateException("Cannot set the address of a radiogram on a non-server connection");
        }
        this.address = ((Radiogram)reference).address;
    }

    public void setLength(int len) {
        throw new IllegalStateException("Not implemented");
    }

    public void setData(byte[] buffer, int offset, int len) {
        throw new IllegalStateException("Not implemented");
    }

    public void reset() {
        this.endOfDataIndex = 1;
        this.payloadIndex = 1;
    }

    public void resetRead() throws IOException {
        this.dis.reset();
    }

    public int available() throws IOException {
        return this.dis.available();
    }

    public void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    public void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        this.dos.writeUTF(str);
    }

    public int getLinkQuality() {
        return this.headerInfo.linkQuality;
    }

    public int getCorr() {
        return this.headerInfo.corr;
    }

    public int getRssi() {
        return this.headerInfo.rssi;
    }

    public int getHopCount() {
        String hopcount = this.headerInfo.getProperty("hopcount");
        return Integer.parseInt(hopcount);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void send() throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        this.timestamp = this.connection.send(this.payload, this.address, this.endOfDataIndex);
    }

    void receive() throws IOException {
        IncomingData receivedData;
        this.reset();
        long timeout = this.connection.getTimeout();
        if (timeout >= 0L) {
            receivedData = this.connection.receivePacket(timeout);
            if (receivedData == null) {
                throw new TimeoutException("Radiogram receive timeout");
            }
        } else {
            receivedData = this.connection.receivePacket();
            if (receivedData == null) {
                throw new InterruptedIOException("Connection was closed");
            }
        }
        System.arraycopy(receivedData.payload, 0, this.payload, 0, receivedData.payload.length);
        this.endOfDataIndex = receivedData.payload.length;
        this.headerInfo = receivedData.headerInfo;
        this.address = this.headerInfo.originator;
        this.timestamp = this.headerInfo.timestamp;
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    RadiogramConnImpl getConnection() {
        return this.connection;
    }

    public long getTimeout() {
        return this.connection.getTimeout();
    }

    private void setRadioPacket(int size) {
        this.payload = new byte[size + 1];
    }

    static /* synthetic */ byte[] access$402(Radiogram x0, byte[] x1) {
        x0.payload = x1;
        return x1;
    }

    private class RadiogramOutputStream
    extends OutputStream {
        private RadiogramOutputStream() {
        }

        public void write(int b) {
            if (Radiogram.this.endOfDataIndex >= Radiogram.this.payload.length) {
                throw new IndexOutOfBoundsException("Radiogram is full");
            }
            ((Radiogram)Radiogram.this).payload[((Radiogram)Radiogram.this).endOfDataIndex++] = (byte)b;
        }

        public void close() throws IOException {
            Radiogram.access$402(Radiogram.this, null);
            super.close();
        }
    }

    private class RadiogramInputStream
    extends InputStream {
        private RadiogramInputStream() {
        }

        public int read() {
            if (Radiogram.this.payloadIndex >= Radiogram.this.endOfDataIndex) {
                return -1;
            }
            return Radiogram.this.payload[Radiogram.this.payloadIndex++] & 0xFF;
        }

        public void close() throws IOException {
            Radiogram.access$402(Radiogram.this, null);
            super.close();
        }

        public int available() {
            return Radiogram.this.endOfDataIndex - Radiogram.this.payloadIndex;
        }

        public void reset() {
            Radiogram.this.payloadIndex = 1;
        }
    }
}

