/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.radiogram;

import com.sun.spot.io.j2me.radiogram.Radiogram;
import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.RadioConnectionBase;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadiogramProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPolicy;
import com.sun.spot.peripheral.radio.RadiogramProtocolManager;
import com.sun.spot.util.IEEEAddress;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Datagram;

public class RadiogramConnImpl
extends RadioConnectionBase
implements RadiogramConnection {
    ConnectionID sendConnectionID;
    ConnectionID receiveConnectionID;
    private static IRadiogramProtocolManager protocolManager;
    private static IRadioPolicyManager radioPolicyManager;

    private static synchronized IRadiogramProtocolManager getProtocolManager() {
        if (protocolManager == null) {
            protocolManager = RadiogramProtocolManager.getInstance();
        }
        return protocolManager;
    }

    public static void setProtocolManager(IRadiogramProtocolManager protocolManager) {
        RadiogramConnImpl.protocolManager = protocolManager;
    }

    public static synchronized IRadioPolicyManager getRadioPolicyManager() {
        if (radioPolicyManager == null) {
            radioPolicyManager = RadioFactory.getRadioPolicyManager();
        }
        return radioPolicyManager;
    }

    public static void setRadioPolicyManager(IRadioPolicyManager manager) {
        radioPolicyManager = manager;
    }

    public RadiogramConnImpl(String addr, byte portNo, boolean isServer, boolean timeouts) {
        if (isServer) {
            this.receiveConnectionID = this.sendConnectionID = RadiogramConnImpl.getProtocolManager().addServerConnection(portNo);
        } else if (addr.toLowerCase().equals("broadcast")) {
            this.sendConnectionID = RadiogramConnImpl.getProtocolManager().addBroadcastConnection(portNo);
            this.sendConnectionID.setMaxBroadcastHops((byte)2);
            this.receiveConnectionID = null;
        } else {
            long macAddress = new IEEEAddress(addr).asLong();
            this.sendConnectionID = RadiogramConnImpl.getProtocolManager().addOutputConnection(macAddress, portNo);
            this.receiveConnectionID = RadiogramConnImpl.getProtocolManager().addInputConnection(macAddress, portNo);
        }
        if (this.receiveConnectionID != null) {
            RadiogramConnImpl.getRadioPolicyManager().registerConnection((IConnectionID)this.receiveConnectionID);
            RadiogramConnImpl.getRadioPolicyManager().policyHasChanged((IConnectionID)this.receiveConnectionID, RadioPolicy.ON);
        }
        if (timeouts) {
            this.setTimeout(10000L);
        }
    }

    public RadiogramConnImpl() {
    }

    public void close() throws IOException {
        if (this.receiveConnectionID != null) {
            RadiogramConnImpl.getProtocolManager().closeConnection(this.receiveConnectionID);
            RadiogramConnImpl.getRadioPolicyManager().deregisterConnection((IConnectionID)this.receiveConnectionID);
            this.receiveConnectionID = null;
            if (this.isServer()) {
                this.sendConnectionID = null;
            }
        }
        if (this.sendConnectionID != null) {
            RadiogramConnImpl.getProtocolManager().closeConnection(this.sendConnectionID);
            this.sendConnectionID = null;
        }
        super.close();
    }

    public int getMaximumLength() {
        return 1260;
    }

    public int getNominalLength() {
        return 1260;
    }

    public void send(Datagram dgram) throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        Radiogram rg = (Radiogram)dgram;
        if (rg.getConnection() != this) {
            throw new IllegalArgumentException("Attempt to send radiogram on unassociated connection");
        }
        ((Radiogram)dgram).send();
    }

    public void receive(Datagram dgram) throws IOException {
        if (this.isBroadcast()) {
            throw new IllegalStateException("Can't receive on broadcast connection");
        }
        Radiogram rg = (Radiogram)dgram;
        if (rg.getConnection() != this) {
            throw new IllegalArgumentException("Attempt to receive radiogram on unassociated connection");
        }
        ((Radiogram)dgram).receive();
    }

    public Datagram newDatagram(int size) {
        return new Radiogram(size, this);
    }

    public Datagram newDatagram(int size, String addr) {
        return new Radiogram(size, this, addr);
    }

    public Datagram newDatagram(byte[] buf, int size) {
        throw new IllegalStateException("Method newDatagram(byte[] buf, int size) is not implemented");
    }

    public Datagram newDatagram(byte[] buf, int size, String addr) {
        throw new IllegalStateException("Method newDatagram(byte[] buf, int size, String addr) is not implemented");
    }

    public boolean isBroadcast() {
        return this.sendConnectionID.isBroadcast();
    }

    public boolean isPointToPoint() {
        return this.sendConnectionID.isOutput();
    }

    public boolean isServer() {
        return this.sendConnectionID.isServer();
    }

    public long getMacAddress() {
        return this.sendConnectionID.getMacAddress();
    }

    public void setRadioPolicy(RadioPolicy policy) {
        if (this.receiveConnectionID == null) {
            throw new IllegalStateException("Can't set radio policy for output-only connections");
        }
        RadiogramConnImpl.getRadioPolicyManager().policyHasChanged((IConnectionID)this.receiveConnectionID, policy);
    }

    public Connection open(String arg0, String arg1, int arg2, boolean arg3) throws IOException {
        throw new SpotFatalException("cannot reopen a connection");
    }

    long send(byte[] payload, long toAddress, int length) throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        return RadiogramConnImpl.getProtocolManager().send(this.sendConnectionID, toAddress, payload, length);
    }

    IncomingData receivePacket(long timeout) {
        return RadiogramConnImpl.getProtocolManager().receivePacket(this.receiveConnectionID, timeout);
    }

    public IncomingData receivePacket() {
        return RadiogramConnImpl.getProtocolManager().receivePacket(this.receiveConnectionID);
    }

    public byte getLocalPort() {
        return this.sendConnectionID.getPortNo();
    }

    public boolean packetsAvailable() {
        return RadiogramConnImpl.getProtocolManager().packetsAvailable(this.receiveConnectionID);
    }

    public void setMaxBroadcastHops(int hops) {
        if (hops > 255) {
            hops = 255;
        }
        this.sendConnectionID.setMaxBroadcastHops((byte)(hops & 0xFF));
    }

    public int getMaxBroadcastHops() {
        return this.sendConnectionID.getMaxBroadcastHops();
    }
}

