/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.radiostream;

import com.sun.spot.peripheral.IRadioControl;
import com.sun.spot.peripheral.TimeoutException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.RadioPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class RadioInputStream
extends InputStream
implements IRadioControl {
    private IRadioPolicyManager radioPolicyManager;
    private static final int BUFFER_SIZE = 256;
    private byte[] payload;
    private int payloadIndex;
    private int endOfDataIndex;
    private LowPanHeaderInfo headerInfo;
    private IRadiostreamProtocolManager protMgr;
    private ConnectionID connectionID;
    private long timeout;
    private boolean closed;

    public RadioInputStream(IRadiostreamProtocolManager dispatcher, ConnectionID cid, long timeout, RadioPolicy initialPolicy, IRadioPolicyManager radioPolicyManager) {
        this.connectionID = cid;
        this.timeout = timeout;
        this.protMgr = dispatcher;
        this.radioPolicyManager = radioPolicyManager;
        this.payload = new byte[256];
        this.endOfDataIndex = this.payloadIndex = 3;
        radioPolicyManager.registerConnection((IConnectionID)this.connectionID);
        radioPolicyManager.policyHasChanged((IConnectionID)this.connectionID, initialPolicy);
        this.closed = false;
    }

    public int read() throws IOException {
        while (this.payloadIndex >= this.endOfDataIndex) {
            this.getPacket();
        }
        return this.payload[this.payloadIndex++] & 0xFF;
    }

    public int available() throws IOException {
        while (this.payloadIndex >= this.endOfDataIndex) {
            if (this.protMgr.packetsAvailable(this.connectionID)) {
                this.getPacket();
                continue;
            }
            return 0;
        }
        return this.endOfDataIndex - this.payloadIndex;
    }

    public int getLinkQuality() {
        return this.headerInfo.linkQuality;
    }

    public int getCorr() {
        return this.headerInfo.corr;
    }

    public int getRssi() {
        return this.headerInfo.rssi;
    }

    private void getPacket() throws IOException {
        IncomingData receivedData;
        if (this.timeout >= 0L) {
            receivedData = this.protMgr.receivePacket(this.connectionID, this.timeout);
            if (receivedData == null) {
                throw new TimeoutException("Radio receive timeout");
            }
        } else {
            receivedData = this.protMgr.receivePacket(this.connectionID);
            if (receivedData == null) {
                throw new InterruptedIOException("Connection was closed");
            }
        }
        System.arraycopy(receivedData.payload, 0, this.payload, 0, receivedData.payload.length);
        this.endOfDataIndex = receivedData.payload.length;
        this.headerInfo = receivedData.headerInfo;
        this.payloadIndex = 3;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.protMgr.closeConnection(this.connectionID);
            this.radioPolicyManager.deregisterConnection((IConnectionID)this.connectionID);
            this.closed = true;
        }
        super.close();
    }

    public void setRadioPolicy(RadioPolicy selection) {
        if (!this.closed) {
            this.radioPolicyManager.policyHasChanged((IConnectionID)this.connectionID, selection);
        }
    }

    public byte getLocalPort() {
        return this.connectionID.getPortNo();
    }

    public void setTimeout(long time) {
        this.timeout = time;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

