/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.radiostream;

import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.IRadioControl;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.peripheral.radio.RadioPolicy;
import java.io.IOException;
import java.io.OutputStream;

public class RadioOutputStream
extends OutputStream
implements IRadioControl {
    private static final int BUFFER_SIZE = 79;
    private byte[] payload;
    private int payloadIndex;
    private IRadiostreamProtocolManager protMgr;
    private int flushThreshold;
    private ConnectionID connectionID;
    private IRadioPolicyManager radioPolicyManager;
    private boolean closed;

    public RadioOutputStream(IRadiostreamProtocolManager dispatcher, ConnectionID cid, RadioPolicy initialPolicy, IRadioPolicyManager radioPolicyManager) {
        this.connectionID = cid;
        this.protMgr = dispatcher;
        this.radioPolicyManager = radioPolicyManager;
        this.payload = new byte[79];
        this.payloadIndex = 3;
        this.flushThreshold = 79;
        radioPolicyManager.registerConnection((IConnectionID)this.connectionID);
        radioPolicyManager.policyHasChanged((IConnectionID)this.connectionID, initialPolicy);
        this.closed = false;
    }

    public synchronized void write(int arg0) throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        this.payload[this.payloadIndex++] = (byte)arg0;
        if (this.payloadIndex == this.flushThreshold) {
            this.sendPayload();
        }
    }

    public synchronized void flush() throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        if (this.payloadIndex > 3) {
            this.sendPayload();
        }
        this.protMgr.waitForAllAcks(this.connectionID);
    }

    private void sendPayload() throws NoMeshLayerAckException, NoAckException, ChannelBusyException, NoRouteException {
        try {
            this.protMgr.send(this.connectionID, this.connectionID.getMacAddress(), this.payload, this.payloadIndex);
        }
        catch (NoAckException e) {
            this.payloadIndex = 3;
            throw e;
        }
        catch (ChannelBusyException e) {
            this.payloadIndex = 3;
            throw e;
        }
        catch (NoRouteException e) {
            this.payloadIndex = 3;
            throw e;
        }
        this.payloadIndex = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                this.flush();
            }
            finally {
                this.payload = null;
                this.protMgr.closeConnection(this.connectionID);
                this.radioPolicyManager.deregisterConnection((IConnectionID)this.connectionID);
                this.closed = true;
            }
        }
        super.close();
    }

    public int getFlushThreshold() {
        return this.flushThreshold - 3;
    }

    public void setFlushThreshold(int ft) {
        int maxFlushThreshold = 76;
        if (ft <= 0 || ft > maxFlushThreshold) {
            throw new IllegalArgumentException("Flush threshold of " + ft + " out of range; should be > 0 and <= " + maxFlushThreshold);
        }
        this.flushThreshold = ft + 3;
    }

    public void setRadioPolicy(RadioPolicy selection) {
        if (!this.closed) {
            this.radioPolicyManager.policyHasChanged((IConnectionID)this.connectionID, selection);
        }
    }

    public byte getLocalPort() {
        return this.connectionID.getPortNo();
    }
}

