/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.networktools;

import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.LowPanStats;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPolicy;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.RouteTable;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingManager;
import com.sun.spot.service.IService;
import com.sun.spot.util.IEEEAddress;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;

public class NetManagementServer
implements Runnable,
IService {
    public static final String systemProperty = "spot.mesh.management.enable";
    public static final int NET_MANAGEMENT_SERVER_PORT = 20;
    public static final int NET_MANAGEMENT_RECEIVE_PORT = 21;
    private static final String name = "NetManagementServer";
    private static final int ROUTE_CMD = 1;
    private static final int STATS_CMD = 2;
    private static final int CONFIG_CMD = 3;
    private static final int ROUTETABLE_CMD = 4;
    private static final int MAX_RETRIES = 3;
    private static RadiogramConnection reqConn;
    private RadiogramConnection respConn;
    private Thread mainThread;
    private int state;
    private static IService netMgr;

    protected NetManagementServer() {
        String meshOn = System.getProperty("spot.mesh.traceroute.enable");
        if (meshOn != null && "true".equalsIgnoreCase(meshOn)) {
            System.out.println("[notice] spot.mesh.traceroute.enable has been deprecated.  \n[notice] Setting new property spot.mesh.management.enable");
            this.setEnabled(true);
            if (!RadioFactory.isRunningOnHost()) {
                System.out.println("[notice] Turning off old property: spot.mesh.traceroute.enable");
                RadioFactory.setPersistentProperty((String)"spot.mesh.traceroute.enable", (String)"false");
            }
            RadioFactory.setProperty((String)"spot.mesh.traceroute.enable", (String)"false");
        }
        if (this.mainThread == null) {
            this.mainThread = new Thread((Runnable)this, name);
        }
        RadioFactory.setAsDaemonThread((Thread)this.mainThread);
        this.state = 0;
    }

    public static void main(String[] args) {
        IService netmgr = NetManagementServer.getNetManagementServer();
        if (netmgr.getEnabled() & !netmgr.isRunning()) {
            netmgr.start();
        }
    }

    public static synchronized IService getNetManagementServer() {
        if (netMgr == null) {
            netMgr = new NetManagementServer();
        }
        return netMgr;
    }

    private static Datagram initRequest(long dest) {
        RadioFactory.setProperty((String)"spot.log.connections", (String)"false");
        try {
            reqConn = (RadiogramConnection)Connector.open((String)("radiogram://" + dest + ":" + 20));
            reqConn.setTimeout(10000L);
            Datagram dg = reqConn.newDatagram(reqConn.getMaximumLength());
            return dg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Datagram initResponse(String dest) {
        try {
            this.respConn = (RadiogramConnection)Connector.open((String)("radiogram://" + dest + ":" + 21));
            Datagram dg = this.respConn.newDatagram(this.respConn.getMaximumLength());
            return dg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void cleanupRequest() {
        if (reqConn != null) {
            try {
                reqConn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void cleanupResponse() {
        if (this.respConn != null) {
            try {
                this.respConn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Datagram makeRequest(Datagram datagram) {
        RadiogramConnection respConn = null;
        Datagram dg = null;
        if (reqConn != null) {
            for (int i = 0; i < 3; ++i) {
                try {
                    respConn = (RadiogramConnection)Connector.open((String)("radiogram://" + datagram.getAddress() + ":" + 21));
                    respConn.setTimeout(8000L);
                    dg = respConn.newDatagram(respConn.getMaximumLength());
                    reqConn.send(datagram);
                    respConn.receive(dg);
                    continue;
                }
                catch (IOException e) {
                    dg = null;
                    continue;
                }
                finally {
                    try {
                        if (respConn != null) {
                            respConn.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return dg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestRoute(long src, long dst) {
        String result = null;
        Datagram dg = NetManagementServer.initRequest(src);
        if (dg != null) {
            dg.reset();
            try {
                dg.writeByte(1);
                dg.writeLong(dst);
                dg = NetManagementServer.makeRequest(dg);
                if (dg != null) {
                    result = dg.readUTF();
                }
                result = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                NetManagementServer.cleanupRequest();
            }
        } else {
            return null;
        }
        return result;
    }

    private void doTraceRoute(Datagram datagram, Datagram response) {
        IRoutingManager routingManager = LowPan.getInstance().getRoutingManager();
        try {
            long requestedAddress = datagram.readLong();
            RouteInfo routeInfo = routingManager.getRouteInfo(requestedAddress);
            response.reset();
            response.writeUTF(routeInfo.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RouteTable requestRouteTable(long target) {
        RouteTable rt = null;
        Datagram dg = NetManagementServer.initRequest(target);
        if (dg != null) {
            dg.reset();
            try {
                dg.writeByte(4);
                dg = NetManagementServer.makeRequest(dg);
                if (dg != null) {
                    int size = dg.readInt();
                    rt = new RouteTable();
                    for (int i = 0; i < size; ++i) {
                        rt.addEntry(new RouteInfo(dg.readLong(), dg.readLong(), dg.readShort()));
                    }
                }
                rt = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                NetManagementServer.cleanupRequest();
            }
        } else {
            return null;
        }
        return rt;
    }

    private void doRouteTable(Datagram datagram, Datagram response) {
        response.reset();
        RouteTable rt = LowPan.getInstance().getRoutingManager().getRoutingTable();
        Enumeration en = rt.getAllEntries();
        try {
            response.writeInt(rt.getSize());
            while (en.hasMoreElements()) {
                RouteInfo ri = (RouteInfo)en.nextElement();
                response.writeLong(ri.destination);
                response.writeLong(ri.nextHop);
                response.writeShort(ri.hopCount);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LowPanStats requestStats(long target) {
        LowPanStats lps = null;
        Datagram dg = NetManagementServer.initRequest(target);
        if (dg != null) {
            dg.reset();
            try {
                dg.writeByte(2);
                dg = NetManagementServer.makeRequest(dg);
                if (dg != null) {
                    int size = dg.readInt();
                    byte[] b = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        b[i] = dg.readByte();
                    }
                    lps = new LowPanStats(b);
                }
                lps = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                NetManagementServer.cleanupRequest();
            }
        } else {
            return null;
        }
        return lps;
    }

    private void doStats(Datagram datagram, Datagram response) {
        response.reset();
        LowPanStats lps = ((LowPan)LowPan.getInstance()).getStatistics();
        byte[] b = lps.toByteArray();
        try {
            response.writeInt(b.length);
            for (int i = 0; i < b.length; ++i) {
                response.writeByte((int)b[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void doConfig(Datagram datagram, Datagram response) {
    }

    public void run() {
        System.out.println("[NetManagementServer] starting on port 20");
        try {
            RadiogramConnection conn = (RadiogramConnection)Connector.open((String)"radiogram://:20");
            conn.setRadioPolicy(RadioPolicy.AUTOMATIC);
            Datagram datagram = conn.newDatagram(conn.getMaximumLength());
            while (this.state != 4) {
                conn.receive(datagram);
                boolean valid = true;
                Datagram response = this.initResponse(datagram.getAddress());
                byte cmd = datagram.readByte();
                switch (cmd) {
                    case 1: {
                        this.doTraceRoute(datagram, response);
                        break;
                    }
                    case 2: {
                        this.doStats(datagram, response);
                        break;
                    }
                    case 3: {
                        this.doConfig(datagram, response);
                        break;
                    }
                    case 4: {
                        this.doRouteTable(datagram, response);
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
                if (!valid) continue;
                try {
                    this.respConn.send(response);
                    this.cleanupResponse();
                }
                catch (IOException e) {
                    System.err.println("[NetManagementServer] failed to send reply to " + new IEEEAddress(response.getAddress()));
                }
            }
            conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.state = 0;
        System.out.println("[NetManagementServer] exiting");
    }

    public void setServiceName(String who) {
    }

    public void setEnabled(boolean enable) {
        if (!RadioFactory.isRunningOnHost()) {
            RadioFactory.setPersistentProperty((String)systemProperty, (String)String.valueOf(enable));
        }
        RadioFactory.setProperty((String)systemProperty, (String)String.valueOf(enable));
    }

    public boolean stop() {
        this.state = 4;
        return true;
    }

    public boolean start() {
        this.state = 1;
        if (this.mainThread != null) {
            this.mainThread.start();
        }
        this.state = this.mainThread != null ? 2 : 0;
        return this.state == 2;
    }

    public boolean resume() {
        return this.start();
    }

    public boolean pause() {
        return this.stop();
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public int getStatus() {
        return this.state;
    }

    public String getName() {
        return this.getServiceName();
    }

    public String getServiceName() {
        return name;
    }

    public boolean getEnabled() {
        String meshOn = System.getProperty(systemProperty);
        return meshOn != null && "true".equalsIgnoreCase(meshOn);
    }
}

