/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.util.IEEEAddress;

public class ConnectionID
implements IConnectionID {
    long macAddress;
    int connectionType;
    byte portNo;
    private byte maxBroadcastHops;

    public ConnectionID() {
    }

    public ConnectionID(long macAddress, byte portNo, int connectionType) {
        this.macAddress = macAddress;
        this.portNo = portNo;
        this.connectionType = connectionType;
        this.maxBroadcastHops = this.connectionType == 3 ? (byte)0 : (byte)2;
    }

    public long getMacAddress() {
        return this.macAddress;
    }

    public boolean isBroadcast() {
        return this.connectionType == 3;
    }

    public boolean isServer() {
        return this.connectionType == 2;
    }

    public boolean isInput() {
        return this.connectionType == 1;
    }

    public boolean isOutput() {
        return this.connectionType == 0;
    }

    public byte getPortNo() {
        return this.portNo;
    }

    public byte getMaxBroadcastHops() {
        return this.maxBroadcastHops;
    }

    public void setMaxBroadcastHops(byte maxHops) {
        this.maxBroadcastHops = maxHops;
    }

    public int hashCode() {
        return ((byte)this.macAddress << 8) + this.portNo;
    }

    public boolean equals(Object c) {
        if (c == null) {
            return false;
        }
        ConnectionID cid = (ConnectionID)c;
        return cid.getMacAddress() == this.macAddress && cid.getPortNo() == this.portNo && cid.getConnectionType() == this.connectionType;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String toString() {
        String name = this.isServer() ? "Server on port " + (this.portNo & 0xFF) : (this.isBroadcast() ? "Broadcast on port " + (this.portNo & 0xFF) : (this.isInput() ? "Input from " + new IEEEAddress(this.macAddress) + " on port " + (this.portNo & 0xFF) : "Output to " + new IEEEAddress(this.macAddress) + " on port " + (this.portNo & 0xFF)));
        return name;
    }

    public boolean canReceive() {
        return this.isServer() || this.isInput();
    }

    public boolean canSend() {
        return this.isOutput() || this.isBroadcast() || this.isServer();
    }

    public void copyFrom(Object o) {
        ConnectionID other = (ConnectionID)o;
        this.connectionType = other.connectionType;
        this.macAddress = other.macAddress;
        this.portNo = other.portNo;
        this.maxBroadcastHops = other.maxBroadcastHops;
    }

    public byte getMaxHops() {
        return this.maxBroadcastHops;
    }

    public void setMaxHops(byte maxHops) {
        this.maxBroadcastHops = maxHops;
    }
}

