/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.BroadcastConnectionState;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.peripheral.radio.RetransmitBuffer;
import com.sun.spot.util.Queue;
import com.sun.squawk.util.IntHashtable;

class ConnectionState {
    static final int INTACT = 0;
    static final int NO_MESHLAYER_ACK = 1;
    static final int NO_ACK = 2;
    static final int NO_ROUTE = 3;
    static final int CHANNEL_BUSY = 4;
    static final int CLOSED = 5;
    int status = 0;
    private Queue queue;
    ConnectionID id;
    int lastIncomingSeq = -1;
    int lastOutgoingSeq = -1;
    private IntHashtable retransBuffers = new IntHashtable();
    IntHashtable reorderTable = new IntHashtable();

    static ConnectionState newInstance(boolean canReceive, ConnectionID cid) {
        if (cid.isBroadcast()) {
            return new BroadcastConnectionState(cid);
        }
        return new ConnectionState(canReceive, cid);
    }

    ConnectionState(boolean canReceive, ConnectionID cid) {
        this.setCanReceive(canReceive);
        this.id = cid;
    }

    public String toString() {
        return "Connection state for " + this.id.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object c) {
        if (c == null) {
            return false;
        }
        ConnectionState cs = (ConnectionState)c;
        return this.id.equals(cs.id);
    }

    IncomingData getQueuedPacket() {
        if (!this.canReceive()) {
            throw new IllegalArgumentException(this.id.toString() + " cannot be used for receiving");
        }
        if (this.status == 5) {
            return null;
        }
        return (IncomingData)this.queue.get();
    }

    IncomingData getQueuedPacket(long timeout) {
        if (!this.canReceive()) {
            throw new IllegalArgumentException(this.id.toString() + " cannot be used for receiving");
        }
        if (this.status == 5) {
            return null;
        }
        return (IncomingData)this.queue.get(timeout);
    }

    boolean packetsAvailable() {
        if (!this.canReceive()) {
            throw new IllegalArgumentException(this.id.toString() + " does not have a received packet queue");
        }
        return !this.queue.isEmpty();
    }

    private boolean canReceive() {
        return this.queue != null;
    }

    private void setCanReceive(boolean b) {
        this.queue = b ? new Queue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilNoRetransBuffers() throws NoAckException, ChannelBusyException, NoMeshLayerAckException, NoRouteException {
        IntHashtable intHashtable = this.retransBuffers;
        synchronized (intHashtable) {
            while (!this.retransBuffers.isEmpty()) {
                try {
                    this.retransBuffers.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.checkStatusAndReport();
        }
    }

    private void checkStatusAndReport() throws NoAckException, ChannelBusyException, NoMeshLayerAckException, NoRouteException {
        if (this.status != 0) {
            int oldStatus = this.status;
            this.status = 0;
            this.lastOutgoingSeq = -1;
            switch (oldStatus) {
                case 2: {
                    throw new NoAckException("NoAckException on " + this);
                }
                case 4: {
                    throw new ChannelBusyException("ChannelBusyException on " + this);
                }
                case 1: {
                    throw new NoMeshLayerAckException("NoMeshLayerAckException on " + this);
                }
                case 3: {
                    throw new NoRouteException("NoRouteException on " + this);
                }
            }
            throw new SpotFatalException("Error - shouldn't throw exception for status " + oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRetransBuffer(byte seqNum, RetransmitBuffer rb) {
        IntHashtable intHashtable = this.retransBuffers;
        synchronized (intHashtable) {
            this.retransBuffers.put((int)seqNum, (Object)rb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRetransBuffer(byte seqNum) {
        IntHashtable intHashtable = this.retransBuffers;
        synchronized (intHashtable) {
            RetransmitBuffer rb = (RetransmitBuffer)this.retransBuffers.remove((int)seqNum);
            if (rb != null) {
                rb.retransmitTimer.cancel();
            }
            this.retransBuffers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RetransmitBuffer getRetransBuffer(byte seqNum) {
        IntHashtable intHashtable = this.retransBuffers;
        synchronized (intHashtable) {
            return (RetransmitBuffer)this.retransBuffers.get((int)seqNum);
        }
    }

    public void emptyReorderTable() {
        this.reorderTable = new IntHashtable();
    }

    public boolean close() {
        this.status = 5;
        if (this.queue != null) {
            this.queue.stop();
        }
        return true;
    }

    void addToQueue(IncomingData data) {
        this.queue.put((Object)data);
    }

    int queueSize() {
        return this.queue.size();
    }
}

