/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.IDataEventListener;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.IRadioPacketDispatcher;
import com.sun.spot.peripheral.radio.IRouteEventListener;
import com.sun.spot.peripheral.radio.LowPanHeader;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.LowPanPacket;
import com.sun.spot.peripheral.radio.LowPanStats;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.peripheral.radio.RadioPacketDispatcher;
import com.sun.spot.peripheral.radio.ReassemblyBuffer;
import com.sun.spot.peripheral.radio.ReassemblyExpiration;
import com.sun.spot.peripheral.radio.mhrp.aodv.AODVManager;
import com.sun.spot.peripheral.radio.mhrp.interfaces.IMHEventListener;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.RoutingPolicyManager;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingManager;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingPolicyManager;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import com.sun.spot.service.IService;
import com.sun.spot.util.Debug;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Queue;
import com.sun.squawk.util.IntHashtable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class LowPan
implements ILowPan,
RouteEventClient {
    private final Object routeLock = new Integer(0);
    private static final int MAX_BROADCAST_DELTA = 30;
    private long ourAddress;
    private Vector dataListener;
    private Vector routeListener;
    private int datagramTag;
    private int broadcastSeqNo;
    private Random randomGen;
    private Queue bCastQueue;
    private BroadcastDispatcherThread bCastDispatcher;
    private static IntHashtable protocolTable;
    private static IntHashtable protocolFamilyTable;
    private static Hashtable availRoutes;
    private static ILowPan lowPan;
    private static IRoutingManager routingManager;
    private static IRadioPacketDispatcher packetDispatcher;
    private static Hashtable reassemblyBuffers;
    private static Hashtable bCastSeqNos;
    private static Timer reassemblyTimer;
    private static IService netmgr;
    private static IRoutingPolicyManager rpm;
    private static LowPanStats lpStats;
    private static final long REASSEMBLEY_EXPIRATION_TIME = 15000L;
    private static final int MAX_BROADCAST_QUEUE_LENGTH = 200;

    public static synchronized ILowPan getInstance() {
        if (lowPan == null) {
            lowPan = new LowPan(RadioFactory.getRadioPolicyManager().getIEEEAddress(), AODVManager.getInstance(), RadioPacketDispatcher.getInstance());
        }
        return lowPan;
    }

    protected LowPan(long ourAddress, IRoutingManager aodvManager, IRadioPacketDispatcher radioPacketDispatcher) {
        this.ourAddress = ourAddress;
        packetDispatcher = radioPacketDispatcher;
        lpStats = new LowPanStats();
        this.randomGen = new Random();
        protocolTable = new IntHashtable();
        protocolFamilyTable = new IntHashtable();
        this.datagramTag = 0;
        reassemblyBuffers = new Hashtable();
        reassemblyTimer = new Timer();
        bCastSeqNos = new Hashtable();
        this.broadcastSeqNo = this.randomGen.nextInt(256);
        this.bCastQueue = new Queue();
        this.bCastDispatcher = new BroadcastDispatcherThread(this);
        this.bCastDispatcher.start();
        rpm = RoutingPolicyManager.getInstance();
        this.routeListener = new Vector();
        this.dataListener = new Vector();
        availRoutes = new Hashtable();
        this.setRoutingManager(aodvManager);
        packetDispatcher.initialize(this);
    }

    public IRoutingManager setRoutingManager(IRoutingManager newRoutingManager) {
        IRoutingManager rm = routingManager;
        if (rm != null) {
            rm.stop();
        }
        if (newRoutingManager != null) {
            newRoutingManager.initialize(this.ourAddress, this);
            newRoutingManager.start();
            routingManager = newRoutingManager;
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProtocolFamily(byte protocolFamily, IProtocolManager protocolMan) {
        if (protocolFamily == 127) {
            throw new IllegalArgumentException("Cannot override SPOT protocol family ");
        }
        if (this.getProtocolFamilyFor(protocolFamily) != null) {
            throw new IllegalArgumentException("Cannot add multiple protocol managers for family: " + protocolFamily);
        }
        IntHashtable intHashtable = protocolFamilyTable;
        synchronized (intHashtable) {
            protocolFamilyTable.put((int)protocolFamily, (Object)protocolMan);
            ++LowPan.lpStats.protocolFamilyCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProtocol(byte protocolNum, IProtocolManager protocolMan) {
        if (this.getProtocolFor(protocolNum) != null) {
            throw new IllegalArgumentException("Cannot add multiple protocol managers for " + protocolNum);
        }
        IntHashtable intHashtable = protocolTable;
        synchronized (intHashtable) {
            protocolTable.put((int)protocolNum, (Object)protocolMan);
            ++LowPan.lpStats.protocolCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterProtocol(byte protocolNum) {
        IntHashtable intHashtable = protocolTable;
        synchronized (intHashtable) {
            Object protMgr = protocolTable.remove((int)protocolNum);
            if (protMgr == null) {
                throw new IllegalArgumentException("Cannot remove protocol manager for unknown protocol " + protocolNum);
            }
            --LowPan.lpStats.protocolCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterProtocolFamily(byte protocolFamily) {
        IntHashtable intHashtable = protocolFamilyTable;
        synchronized (intHashtable) {
            Object protMgr = protocolFamilyTable.remove((int)protocolFamily);
            if (protMgr == null) {
                throw new IllegalArgumentException("Cannot remove protocol manager for unknown protocol " + protocolFamily);
            }
            --LowPan.lpStats.protocolFamilyCount;
        }
    }

    public void registerDataEventListener(IDataEventListener dataListener) {
        this.dataListener.addElement(dataListener);
    }

    public void registerRouteEventListener(IRouteEventListener routeListener) {
        this.routeListener.addElement(routeListener);
    }

    public void registerMHEventListener(IMHEventListener mhListener) {
        routingManager.registerEventListener(mhListener);
    }

    public void deregisterDataEventListener(IDataEventListener listener) {
        this.dataListener.removeElement(listener);
    }

    public void deregisterRouteEventListener(IRouteEventListener listener) {
        this.routeListener.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routeFound(RouteInfo info, Object uniqueKey) {
        Object object = this.routeLock;
        synchronized (object) {
            availRoutes.put(uniqueKey, info);
            this.routeLock.notifyAll();
        }
    }

    public synchronized void receive(RadioPacket packet) throws ChannelBusyException, NoRouteException {
        LowPanPacket lpp = new LowPanPacket(packet);
        if (lpp.isMeshed()) {
            ++LowPan.lpStats.meshPacketsReceived;
            if (lpp.getFDestinationAddress() - this.ourAddress == 0L) {
                if (lpp.isFragged()) {
                    this.reassembly(lpp);
                } else {
                    int dataStart = lpp.getLppPayloadOffset();
                    int dataLength = lpp.getPayloadSize();
                    this.readPacket(lpp, dataStart, dataLength);
                }
            } else if (!lpp.isBCast() && !rpm.isEndNode()) {
                this.forwardMeshPacket(lpp);
            } else if (lpp.getOriginatorAddress() != this.ourAddress && this.validateBroadcastForForwarding(lpp)) {
                ++LowPan.lpStats.meshBroadcastsReceived;
                if (lpp.isFragged()) {
                    this.reassembly(lpp);
                } else {
                    int dataStart = lpp.getLppPayloadOffset();
                    int dataLength = lpp.getPayloadSize();
                    if (dataLength < 0) {
                        System.out.println("[LowPan] Received packet with apparently negative data length");
                        System.out.println("RadioPacket: " + packet);
                    } else {
                        this.readPacket(lpp, dataStart, dataLength);
                    }
                }
                if (!rpm.isEndNode() && lpp.getHopsLeft() > 1) {
                    this.queueBroadcastPacket(lpp);
                }
            } else {
                ++LowPan.lpStats.droppedBroadcasts;
            }
        } else {
            ++LowPan.lpStats.nonMeshPacketsReceived;
            if (lpp.isFragged()) {
                this.reassembly(lpp);
            } else {
                int dataStart = lpp.getLppPayloadOffset();
                int dataLength = lpp.getPayloadSize();
                if (dataLength < 0) {
                    System.out.println("[LowPan] Received packet with apparently negative data length");
                    System.out.println("RadioPacket: " + packet);
                } else {
                    this.readPacket(lpp, dataStart, dataLength);
                }
            }
        }
    }

    private boolean validateBroadcastForForwarding(LowPanPacket lpp) throws ChannelBusyException, NoRouteException {
        Integer lastSeqNo = (Integer)bCastSeqNos.get(new Long(lpp.getOriginatorAddress()));
        if (lastSeqNo == null) {
            bCastSeqNos.put(new Long(lpp.getOriginatorAddress()), new Integer(lpp.getBCastSeqNo() & 0xFF));
            return true;
        }
        int limit = lastSeqNo;
        int current = lpp.getBCastSeqNo();
        if (current <= limit ? current > limit - 30 : limit - 30 + 255 < current) {
            return false;
        }
        bCastSeqNos.put(new Long(lpp.getOriginatorAddress()), new Integer(lpp.getBCastSeqNo() & 0xFF));
        return true;
    }

    public IRoutingManager getRoutingManager() {
        return routingManager;
    }

    public IService getNetManager() {
        return netmgr;
    }

    public IRoutingPolicyManager getRoutingPolicyManager() {
        return rpm;
    }

    public long send(byte protocolFamily, byte protocolNum, long toAddress, byte[] buffer, int startOffset, int endOffset) throws ChannelBusyException, NoRouteException {
        LowPanPacket lpp = new LowPanPacket(1);
        this.sendPrim(protocolFamily, protocolNum, toAddress, buffer, startOffset, endOffset, false, lpp);
        return lpp.getRadioPacket().getTimestamp();
    }

    public boolean send(byte protocolFamily, byte protocolNum, long toAddress, byte[] buffer, int startOffset, int endOffset, boolean failIfNotSingleHop) throws ChannelBusyException, NoRouteException {
        return this.sendPrim(protocolFamily, protocolNum, toAddress, buffer, startOffset, endOffset, failIfNotSingleHop, new LowPanPacket(1));
    }

    private boolean sendPrim(byte protocolFamily, byte protocolNum, long toAddress, byte[] buffer, int startOffset, int endOffset, boolean failIfNotSingleHop, LowPanPacket lpp) throws ChannelBusyException, NoRouteException {
        LowPanHeader lph = new LowPanHeader();
        lph.setProtocolInfo(protocolFamily, protocolNum);
        IProtocolManager protocolManager = protocolFamily == 127 ? this.getProtocolFor(protocolNum) : this.getProtocolFamilyFor(protocolFamily);
        if (protocolManager == null) {
            throw new IllegalArgumentException("Unknown protocol " + protocolNum);
        }
        boolean result = true;
        RouteInfo info = routingManager.getRouteInfo(toAddress);
        if (info.nextHop == -1L) {
            info = this.findNextHop(toAddress);
        }
        lpp.getRadioPacket().setDestinationAddress(info.nextHop);
        byte freeSpace = 100;
        freeSpace = (byte)(freeSpace - 2);
        if (info.hopCount > 1) {
            freeSpace = (byte)(freeSpace - 17);
        }
        for (int i = 0; i < 3; ++i) {
            try {
                if (freeSpace >= endOffset - startOffset) {
                    if (info.hopCount > 1 && failIfNotSingleHop) {
                        result = false;
                        return result;
                    }
                    this.sendInOnePacket(info, protocolNum, buffer, startOffset, endOffset, lpp, lph);
                    ++LowPan.lpStats.unicastsSent;
                    return result;
                }
                if (failIfNotSingleHop) {
                    throw new RuntimeException("The failIfNotSingleHop facility is not compatible with payloads that need fragmentation");
                }
                freeSpace = (byte)(freeSpace - 5);
                this.sendInFragments(info, protocolNum, buffer, startOffset, endOffset, lpp, lph, freeSpace);
                ++LowPan.lpStats.unicastsSent;
                ++LowPan.lpStats.unicastsFragmented;
                return result;
            }
            catch (NoAckException e) {
                continue;
            }
        }
        routingManager.invalidateRoute(this.ourAddress, info.destination);
        try {
            info = this.findNextHop(toAddress);
        }
        catch (NoRouteException nre) {
            throw new NoRouteException("[LowPan] received a NoAckException on route to " + new IEEEAddress(toAddress) + " through " + new IEEEAddress(info.nextHop));
        }
        this.send(protocolFamily, protocolNum, toAddress, buffer, startOffset, endOffset, failIfNotSingleHop);
        return result;
    }

    public void sendWithoutMeshingOrFragmentation(byte protocolNum, long toAddress, byte[] buffer, int startOffset, int endOffset) throws NoAckException, ChannelBusyException {
        LowPanPacket lpp = new LowPanPacket(1);
        LowPanHeader lph = new LowPanHeader();
        lph.setOutgoingDestinationAddress(toAddress);
        lph.setProtocolInfo((byte)127, protocolNum);
        lph.setMeshed(false);
        lph.setBCast(false);
        lph.setFragged(false);
        lph.setOutgoingFragTag(0);
        lpp.writeHeaderAndPayload(lph, buffer, startOffset, endOffset);
        lpp.getRadioPacket().setDestinationAddress(toAddress);
        if (toAddress == 65535L) {
            ++LowPan.lpStats.broadcastsSent;
        } else {
            ++LowPan.lpStats.unicastsSent;
        }
        ++LowPan.lpStats.nonMeshPacketsSent;
        ++LowPan.lpStats.packetsSent;
        packetDispatcher.sendPacket(lpp.getRadioPacket());
    }

    public long sendBroadcast(byte protocolNum, byte[] buffer, int startOffset, int endOffset, int hops) throws ChannelBusyException {
        return this.sendBroadcast((byte)127, protocolNum, buffer, startOffset, endOffset, hops);
    }

    public long sendBroadcast(byte protocolFamily, byte protocolNum, byte[] buffer, int startOffset, int endOffset, int hops) throws ChannelBusyException {
        LowPanPacket lpp = new LowPanPacket(2);
        LowPanHeader lph = new LowPanHeader();
        lph.setProtocolInfo(protocolFamily, protocolNum);
        byte freeSpace = 98;
        long dest = 65535L;
        if (hops > 1) {
            lph.setMeshed(true);
            lph.setOutgoingHops(hops);
            lph.setOutgoingOriginatorAddress(this.ourAddress);
            lph.setOutgoingDestinationAddress(dest);
            lph.setBCast(true);
            freeSpace = (byte)(freeSpace - 19);
        } else {
            lph.setMeshed(false);
        }
        try {
            if (freeSpace >= endOffset - startOffset) {
                this.sendInOnePacket(null, protocolNum, buffer, startOffset, endOffset, lpp, lph);
                ++LowPan.lpStats.broadcastsSent;
            } else {
                freeSpace = (byte)(freeSpace - 5);
                this.sendInFragments(null, protocolNum, buffer, startOffset, endOffset, lpp, lph, freeSpace);
                ++LowPan.lpStats.broadcastsSent;
                ++LowPan.lpStats.broadcastsFragmented;
            }
        }
        catch (NoAckException e) {
            throw new SpotFatalException("Should never get a NoAck when broadcasting");
        }
        catch (NoRouteException e) {
            throw new SpotFatalException("Should never get a NoRoute when broadcasting");
        }
        return lpp.getRadioPacket().getTimestamp();
    }

    private void setSequenceNumber(LowPanHeader lph) {
        if (lph.isBCast()) {
            lph.setOutgoingBCastSeqNo(this.broadcastSeqNo++);
            this.broadcastSeqNo %= 256;
            bCastSeqNos.put(new Long(this.ourAddress), new Integer(this.broadcastSeqNo - 1));
        }
    }

    private void sendInOnePacket(RouteInfo routeInfoOrNull, byte protocolNum, byte[] buffer, int startOffset, int endOffset, LowPanPacket lpp, LowPanHeader lph) throws ChannelBusyException, NoRouteException, NoAckException {
        boolean isMeshing = routeInfoOrNull != null && routeInfoOrNull.hopCount > 1;
        lph.setOutgoingFragType(0);
        if (isMeshing) {
            lph.setMeshed(true);
            lph.setOutgoingHops(routeInfoOrNull.hopCount);
            lph.setOutgoingOriginatorAddress(this.ourAddress);
            lph.setOutgoingDestinationAddress(routeInfoOrNull.destination);
        }
        if (lph.isBCast()) {
            ++LowPan.lpStats.meshBroadcastsSent;
            this.setSequenceNumber(lph);
        }
        lpp.writeHeaderAndPayload(lph, buffer, startOffset, endOffset);
        if (isMeshing || lph.isBCast()) {
            ++LowPan.lpStats.meshPacketsSent;
        } else {
            ++LowPan.lpStats.nonMeshPacketsSent;
        }
        ++LowPan.lpStats.packetsSent;
        packetDispatcher.sendPacket(lpp.getRadioPacket());
    }

    private void sendInFragments(RouteInfo routeInfoOrNull, byte protocolNum, byte[] buffer, int startOffset, int endOffset, LowPanPacket lpp, LowPanHeader lph, byte freeSpace) throws NoAckException, ChannelBusyException {
        boolean isMeshing;
        ++this.datagramTag;
        boolean bl = isMeshing = routeInfoOrNull != null && routeInfoOrNull.hopCount > 1;
        if (isMeshing) {
            lph.setMeshed(true);
            lph.setOutgoingHops(routeInfoOrNull.hopCount);
            lph.setOutgoingOriginatorAddress(this.ourAddress);
            lph.setOutgoingDestinationAddress(routeInfoOrNull.destination);
        }
        lph.setFragged(true);
        freeSpace = (byte)(freeSpace - freeSpace % 8);
        lph.setOutgoingFragTag(this.datagramTag);
        lph.setOutgoingFragSize(endOffset - startOffset);
        int numOfFragments = (endOffset - startOffset + freeSpace - 1) / freeSpace;
        for (int i = 0; i < numOfFragments - 1; ++i) {
            if (i == 0) {
                lph.setOutgoingFragType(2);
            } else {
                lph.setOutgoingFragType(3);
            }
            int datagramOffset = i * freeSpace / 8;
            lph.setOutgoingFragOffset(datagramOffset);
            if (lph.isBCast()) {
                ++LowPan.lpStats.meshBroadcastsSent;
                this.setSequenceNumber(lph);
            }
            lpp.writeHeaderAndPayload(lph, buffer, datagramOffset * 8, datagramOffset * 8 + freeSpace);
            if (lpp.getRadioPacket().getDestinationAddress() == 65535L) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (isMeshing || lph.isBCast()) {
                ++LowPan.lpStats.meshPacketsSent;
            } else {
                ++LowPan.lpStats.nonMeshPacketsSent;
            }
            ++LowPan.lpStats.packetsSent;
            packetDispatcher.sendPacket(lpp.getRadioPacket());
        }
        lph.setOutgoingFragType(1);
        byte datagramOffset = (byte)((numOfFragments - 1) * freeSpace / 8);
        lph.setOutgoingFragOffset(datagramOffset);
        if (lph.isBCast()) {
            ++LowPan.lpStats.meshBroadcastsSent;
            this.setSequenceNumber(lph);
        }
        lpp.writeHeaderAndPayload(lph, buffer, startOffset + (numOfFragments - 1) * freeSpace, endOffset);
        if (isMeshing || lph.isBCast()) {
            ++LowPan.lpStats.meshPacketsSent;
        } else {
            ++LowPan.lpStats.nonMeshPacketsSent;
        }
        ++LowPan.lpStats.packetsSent;
        packetDispatcher.sendPacket(lpp.getRadioPacket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouteInfo findNextHop(long destinationAddress) throws NoRouteException {
        Object en;
        RouteInfo info = null;
        Object uniqueKey = new Object();
        if (!this.routeListener.isEmpty()) {
            en = this.routeListener.elements();
            while (en.hasMoreElements()) {
                ((IRouteEventListener)en.nextElement()).routeRequestMade(destinationAddress);
            }
        }
        try {
            en = this.routeLock;
            synchronized (en) {
                routingManager.findRoute(destinationAddress, this, uniqueKey);
                while (!availRoutes.containsKey(uniqueKey)) {
                    this.routeLock.wait();
                }
                info = (RouteInfo)availRoutes.remove(uniqueKey);
                if (info.nextHop - -1L == 0L) {
                    if (!this.routeListener.isEmpty()) {
                        Enumeration en2 = this.routeListener.elements();
                        while (en2.hasMoreElements()) {
                            ((IRouteEventListener)en2.nextElement()).routeResponseReceived(info.destination, -1, false);
                        }
                    }
                    throw new NoRouteException("No route found");
                }
                if (!this.routeListener.isEmpty()) {
                    Enumeration en3 = this.routeListener.elements();
                    while (en3.hasMoreElements()) {
                        ((IRouteEventListener)en3.nextElement()).routeResponseReceived(info.getDestination(), info.hopCount, true);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            System.err.println("findNextHop: interrupted during find route");
        }
        return info;
    }

    private void readPacket(LowPanPacket lpp, int startPos, int length) {
        IProtocolManager protocolManager = null;
        byte protocolNum = lpp.getProtocol();
        byte protocolFamily = lpp.getProtocolFamily();
        protocolManager = protocolFamily == 127 ? this.getProtocolFor(protocolNum) : this.getProtocolFamilyFor(protocolFamily);
        if (protocolManager == null) {
            ++LowPan.lpStats.protocolHandlerMissing;
        } else {
            byte[] rpPayload = new byte[length];
            System.arraycopy(lpp.getRadioPacket().buffer, startPos, rpPayload, 0, length);
            LowPanHeaderInfo lpHeaderInfo = null;
            RadioPacket packet = lpp.getRadioPacket();
            lpHeaderInfo = lpp.isMeshed() ? new LowPanHeaderInfo(packet.getDestinationAddress(), packet.getSourceAddress(), packet.getRssi(), packet.getCorr(), packet.getLinkQuality(), packet.getDestinationPanID(), packet.getSourcePanID(), false, lpp.getOriginatorAddress(), lpp.getFDestinationAddress(), lpp.getHopsLeft(), packet.getTimestamp()) : new LowPanHeaderInfo(packet.getDestinationAddress(), packet.getSourceAddress(), packet.getRssi(), packet.getCorr(), packet.getLinkQuality(), packet.getDestinationPanID(), packet.getSourcePanID(), false, packet.getSourceAddress(), packet.getDestinationAddress(), 0, packet.getTimestamp());
            if (packet.getDestinationAddress() == 65535L) {
                ++LowPan.lpStats.broadcastsReceived;
            } else {
                ++LowPan.lpStats.unicastsReceived;
            }
            protocolManager.processIncomingData(rpPayload, lpHeaderInfo);
        }
    }

    private void queueBroadcastPacket(LowPanPacket lpp) {
        if (this.bCastQueue.size() < 200) {
            this.bCastQueue.put((Object)lpp);
        } else {
            ++LowPan.lpStats.broadcastsQueueFull;
        }
    }

    private void forwardMeshPacket(LowPanPacket lpp) throws ChannelBusyException {
        long nextHop;
        long lastHop;
        block9: {
            lastHop = 0L;
            nextHop = 0L;
            lpp.setHopsLeft(lpp.getHopsLeft() - 1);
            if (lpp.getHopsLeft() <= 0) {
                ++LowPan.lpStats.ttlExpired;
                return;
            }
            if (lpp.isBCast()) {
                ++LowPan.lpStats.meshBroadcastsForwarded;
                lastHop = 65535L;
                nextHop = 65535L;
            } else {
                RouteInfo info = routingManager.getRouteInfo(lpp.getFDestinationAddress());
                routingManager.getRouteInfo(lpp.getOriginatorAddress());
                if (info.nextHop != -1L) {
                    lpp.getRadioPacket().setDestinationAddress(info.nextHop);
                    lastHop = lpp.getRPSourceAddress();
                    nextHop = info.nextHop;
                } else {
                    return;
                }
            }
            try {
                ++LowPan.lpStats.packetsForwarded;
                packetDispatcher.sendPacket(lpp.getRadioPacket());
            }
            catch (NoAckException e) {
                if (lpp.isBCast()) break block9;
                routingManager.invalidateRoute(lpp.getOriginatorAddress(), lpp.getFDestinationAddress());
                return;
            }
        }
        if (!this.dataListener.isEmpty()) {
            Enumeration en = this.dataListener.elements();
            while (en.hasMoreElements()) {
                ((IDataEventListener)en.nextElement()).notifyForward(lastHop, nextHop, lpp.getOriginatorAddress(), lpp.getFDestinationAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProtocolManager getProtocolFamilyFor(byte protocolFam) {
        IntHashtable intHashtable = protocolFamilyTable;
        synchronized (intHashtable) {
            return (IProtocolManager)protocolFamilyTable.get((int)protocolFam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProtocolManager getProtocolFor(byte protocolNum) {
        IntHashtable intHashtable = protocolTable;
        synchronized (intHashtable) {
            return (IProtocolManager)protocolTable.get((int)protocolNum);
        }
    }

    private void reassembly(LowPanPacket lpp) {
        ++LowPan.lpStats.fragmentsReceived;
        long originator = lpp.isMeshed() ? lpp.getOriginatorAddress() : lpp.getRPSourceAddress();
        long destination = this.ourAddress;
        short datagramTag = lpp.getFragTag();
        short datagramSize = lpp.getFragSize();
        int datagramOffset = lpp.isFirstFrag() ? 0 : lpp.getFragOff() & 0xFF;
        String key = Long.toString(originator) + Long.toString(destination) + Integer.toString(datagramTag) + Integer.toString(datagramSize);
        ReassemblyBuffer rb = (ReassemblyBuffer)reassemblyBuffers.get(key);
        if (rb == null) {
            rb = new ReassemblyBuffer(datagramSize);
            reassemblyBuffers.put(key, rb);
            ReassemblyExpiration ex = new ReassemblyExpiration(key, reassemblyBuffers, lpStats);
            reassemblyTimer.schedule((TimerTask)ex, 15000L);
        }
        if (lpp.isFirstFrag()) {
            rb.protocolNumber = lpp.getProtocol();
            rb.protocolFamily = lpp.getProtocolFamily();
        }
        int firstByte = lpp.getLppPayloadOffset();
        int fragmentLength = lpp.getPayloadSize();
        boolean success = rb.write(datagramOffset, lpp.getRadioPacket(), firstByte, fragmentLength);
        if (!success) {
            reassemblyBuffers.remove(key);
            return;
        }
        if (rb.isComplete()) {
            LowPanHeaderInfo lpHeaderInfo;
            RadioPacket packet;
            if (lpp.isMeshed()) {
                packet = lpp.getRadioPacket();
                lpHeaderInfo = new LowPanHeaderInfo(packet.getDestinationAddress(), packet.getSourceAddress(), packet.getRssi(), packet.getCorr(), packet.getLinkQuality(), packet.getDestinationPanID(), packet.getSourcePanID(), true, lpp.getOriginatorAddress(), lpp.getFDestinationAddress(), lpp.getHopsLeft(), packet.getTimestamp());
                if (lpp.getFDestinationAddress() == 65535L) {
                    ++LowPan.lpStats.broadcastsReceived;
                } else {
                    ++LowPan.lpStats.unicastsReceived;
                }
            } else {
                packet = lpp.getRadioPacket();
                lpHeaderInfo = new LowPanHeaderInfo(packet.getDestinationAddress(), packet.getSourceAddress(), packet.getRssi(), packet.getCorr(), packet.getLinkQuality(), packet.getDestinationPanID(), packet.getSourcePanID(), true, packet.getSourceAddress(), packet.getDestinationAddress(), 0, packet.getTimestamp());
                if (packet.getDestinationAddress() == 65535L) {
                    ++LowPan.lpStats.broadcastsReceived;
                } else {
                    ++LowPan.lpStats.unicastsReceived;
                }
            }
            ++LowPan.lpStats.datagramsReassembled;
            reassemblyBuffers.remove(key);
            IProtocolManager pm = rb.protocolFamily == 127 ? this.getProtocolFor(rb.protocolNumber) : this.getProtocolFamilyFor(rb.protocolFamily);
            if (pm != null) {
                pm.processIncomingData(rb.buffer, lpHeaderInfo);
            } else {
                ++LowPan.lpStats.protocolHandlerMissing;
            }
        }
    }

    public void setOurAddress(long addr) {
        this.ourAddress = addr;
    }

    public LowPanStats getStatistics() {
        return lpStats.clone();
    }

    private class BroadcastDispatcherThread
    extends Thread {
        LowPan lowpan;

        BroadcastDispatcherThread(LowPan lp) {
            super("BroadcastDispatcher");
            this.lowpan = lp;
        }

        private void monitorQueue() {
            while (true) {
                LowPanPacket lpp = null;
                while (lpp == null) {
                    lpp = (LowPanPacket)LowPan.this.bCastQueue.get();
                }
                int delay = LowPan.this.randomGen.nextInt(10);
                try {
                    BroadcastDispatcherThread.sleep(delay * 13);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this.lowpan.forwardMeshPacket(lpp);
                    continue;
                }
                catch (ChannelBusyException e) {
                    ++lpStats.droppedBroadcasts;
                    Debug.print("[lowpan] Channel Busy: Broadcast discarded", 2);
                    continue;
                }
                break;
            }
        }

        public void run() {
            this.monitorQueue();
        }
    }
}

