/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

public class LowPanHeader {
    private boolean meshed;
    private boolean fragged;
    private boolean bCast;
    private int hops = 2;
    private int bCastSeqNo = 0;
    private int fragType = 0;
    private int fragTag;
    private int fragSize = 0;
    private int fragOffset = 0;
    private int protocolFamily;
    private int protocolNo;
    private int origLen = 8;
    private int destLen = 8;
    private long outgoingOriginatorAddress = 0L;
    private long outgoingDestinationAddress = 0L;
    protected static final byte UNFRAGMENTED = 0;
    protected static final byte LAST_FRAGMENT = 1;
    protected static final byte FIRST_FRAGMENT = 2;
    protected static final byte INTERIOR_FRAGMENT = 3;
    public static final byte DISPATCH_LOWPAN_IPV6 = 65;
    public static final byte DISPATCH_LOWPAN_HC1 = 66;
    public static final byte DISPATCH_LOWPAN_BC0 = 80;
    public static final byte DISPATCH_ESC = 127;
    public static final byte DISPATCH_SPOT = 127;
    public static final byte FAMILY_DEFINED_PROTO = -1;
    protected static final byte DISPATCH_FRAG = -64;
    protected static final byte DISPATCH_MESH = -128;
    protected static final byte MAX_PROTOCOL_HEADER_LENGTH = 2;
    protected static final byte BROADCAST_HEADER_LENGTH = 2;
    protected static final byte MAX_FRAGMENTATION_HEADER_LENGTH = 5;
    protected static final byte MAX_MESH_HEADER_LENGTH = 17;
    public static final byte MAX_UNFRAG_HEADER_LENGTH = 21;

    public int getLength() {
        int len = 0;
        if (this.isMeshed()) {
            len += 1 + this.destLen + this.origLen;
        }
        len += this.isExtendedHops() ? 1 : 0;
        if (this.isBCast()) {
            len += 2;
        }
        if (this.isFragged()) {
            len += 5;
            if (this.isFirstFrag()) {
                --len;
            }
        }
        return len += this.isExtendedProtocol() ? 2 : 1;
    }

    public boolean isFirstFrag() {
        return this.fragType == 2;
    }

    public boolean isExtendedProtocol() {
        return (this.protocolFamily & 0x7F) == 127;
    }

    public int getOutgoingHops() {
        return this.hops;
    }

    public void setOutgoingHops(int outgoingHops) {
        this.hops = outgoingHops;
    }

    private boolean isExtendedHops() {
        return this.hops > 14;
    }

    public int getOutgoingBCastSeqNo() {
        return this.bCastSeqNo & 0xFF;
    }

    public void setOutgoingBCastSeqNo(int outgoingBCastSeqNo) {
        this.bCastSeqNo = outgoingBCastSeqNo;
    }

    public int getOutgoingFragType() {
        return this.fragType;
    }

    public void setOutgoingFragType(int outgoingFragType) {
        this.fragType = outgoingFragType;
    }

    public int getOutgoingFragTag() {
        return this.fragTag;
    }

    public void setOutgoingFragTag(int outgoingFragTag) {
        this.fragTag = outgoingFragTag;
    }

    public int getOutgoingFragSize() {
        return this.fragSize;
    }

    public void setOutgoingFragSize(int outgoingFragSize) {
        this.fragSize = outgoingFragSize;
    }

    public byte getOutgoingFragOffset() {
        return (byte)(this.fragOffset & 0xFF);
    }

    public void setOutgoingFragOffset(int outgoingFragOffset) {
        this.fragOffset = outgoingFragOffset;
    }

    public long getOutgoingOriginatorAddress() {
        return this.outgoingOriginatorAddress;
    }

    public void setOutgoingOriginatorAddress(long outgoingOriginatorAddress) {
        this.outgoingOriginatorAddress = outgoingOriginatorAddress;
    }

    public long getOutgoingDestinationAddress() {
        return this.outgoingDestinationAddress;
    }

    public void setOutgoingDestinationAddress(long outgoingDestinationAddress) {
        this.outgoingDestinationAddress = outgoingDestinationAddress;
    }

    public byte getProtocolNo() {
        return (byte)(this.protocolNo & 0xFF);
    }

    public boolean isMeshed() {
        return this.meshed;
    }

    public void setMeshed(boolean meshed) {
        this.meshed = meshed;
    }

    public boolean isFragged() {
        return this.fragged;
    }

    public void setFragged(boolean fragged) {
        this.fragged = fragged;
    }

    public boolean isBCast() {
        return this.bCast;
    }

    public void setBCast(boolean bCast) {
        this.bCast = bCast;
    }

    public byte getProtocolFamily() {
        return (byte)(this.protocolFamily & 0xFF);
    }

    public void setProtocolInfo(byte protocolFamily, byte protocolNo) {
        this.protocolFamily = protocolFamily;
        this.protocolNo = protocolNo;
    }
}

