/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.HeaderInfoBase;
import com.sun.spot.util.IEEEAddress;

public class LowPanHeaderInfo
extends HeaderInfoBase {
    public int rssi;
    public int corr;
    public int linkQuality;
    public long originator;
    public long timestamp;
    private int destinationPanID;
    private int sourcePanID;
    private long finalDestination;
    private long hopCount;
    private boolean fragmented;
    private boolean meshDelivery;

    public LowPanHeaderInfo(long destinationAddress, long sourceAddress, int rssi, int corr, int linkQuality, int destinationPanID, int sourcePanID, boolean fragmented, long originator, long finalDestination, byte hopCount, long timestamp) {
        super(destinationAddress, sourceAddress);
        this.rssi = rssi;
        this.corr = corr;
        this.linkQuality = linkQuality;
        this.destinationPanID = destinationPanID;
        this.sourcePanID = sourcePanID;
        this.fragmented = fragmented;
        this.meshDelivery = true;
        this.originator = originator;
        this.finalDestination = finalDestination;
        this.hopCount = hopCount;
        this.timestamp = timestamp;
    }

    public String getProperty(String key) {
        if (key.toLowerCase().equals("sourceaddress")) {
            return new IEEEAddress(this.sourceAddress).asDottedHex();
        }
        if (key.toLowerCase().equals("destinationaddress")) {
            return new IEEEAddress(this.destinationAddress).asDottedHex();
        }
        if (key.toLowerCase().equals("rssi")) {
            return Integer.toString(this.rssi);
        }
        if (key.toLowerCase().equals("corr")) {
            return Integer.toString(this.corr);
        }
        if (key.toLowerCase().equals("linkquality")) {
            return Integer.toString(this.linkQuality);
        }
        if (key.toLowerCase().equals("destinationpanid")) {
            return Integer.toString(this.destinationPanID);
        }
        if (key.toLowerCase().equals("sourcepanid")) {
            return Integer.toString(this.sourcePanID);
        }
        if (key.toLowerCase().equals("originator")) {
            return new IEEEAddress(this.originator).asDottedHex();
        }
        if (key.toLowerCase().equals("finaldestination")) {
            return new IEEEAddress(this.finalDestination).asDottedHex();
        }
        if (key.toLowerCase().equals("hopcount") & this.meshDelivery) {
            return Long.toString(this.hopCount);
        }
        if (key.toLowerCase().equals("meshdelivery")) {
            if (this.meshDelivery) {
                return "true";
            }
            return "false";
        }
        if (key.toLowerCase().equals("fragmented")) {
            if (this.fragmented) {
                return "true";
            }
            return "false";
        }
        throw new IllegalArgumentException("RadioMACHeaderInfo.getProperty: " + key + " is no legal argument. Valid arguments: sourceAddress, " + "destinationAddress, rssi, corr, linkQuality, " + "destinationPanID, sourcePanID, meshDelivery, fragmented, " + "originator, finalDestination or hopCount");
    }
}

