/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.LowPanHeader;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.util.IEEEAddress;

public class LowPanPacket {
    protected static final byte DISPATCH_MASK = 63;
    private static final byte F_BIT = 16;
    private static final byte O_BIT = 32;
    private static final byte HOPSLEFT_BITS = 15;
    private static final byte FRAG_FIRST = -64;
    private static final byte FRAG_INTERIOR = -32;
    private static final byte FRAG_LAST = -32;
    protected static final int DATA_PACKET = 1;
    protected static final int BROADCAST_PACKET = 2;
    private RadioPacket rp;
    private boolean meshed;
    private int meshIndex;
    private boolean extendedHops;
    private int hopsLeftIndex;
    private int origAddrIndex;
    private int destAddrIndex;
    private int destLen;
    private int origLen;
    private boolean bCast;
    private int bCastIndex;
    private boolean fragged;
    private int fragIndex;
    private int fragTagIndex;
    private int fragSizeIndex;
    private int fragOffsetIndex;
    private boolean extendedProtocol;
    private int protocolDispatchIndex;
    private int protocolIndex;
    private int lppPayloadOffset;
    private int lppPayloadSize;
    private int parseIndex;

    public LowPanPacket(int type) {
        this.meshed = false;
        this.hopsLeftIndex = 0;
        this.meshIndex = 0;
        this.extendedHops = false;
        this.origLen = 8;
        this.destLen = 8;
        this.destAddrIndex = 0;
        this.origAddrIndex = 0;
        this.bCast = false;
        this.bCastIndex = 0;
        this.fragged = false;
        this.fragOffsetIndex = 0;
        this.fragSizeIndex = 0;
        this.fragTagIndex = 0;
        this.lppPayloadSize = 0;
        this.lppPayloadOffset = 0;
        this.protocolIndex = 0;
        this.parseIndex = 0;
        switch (type) {
            case 1: {
                this.rp = RadioPacket.getDataPacket();
                break;
            }
            case 2: {
                this.rp = RadioPacket.getBroadcastPacket();
                break;
            }
        }
    }

    public LowPanPacket(RadioPacket packet) {
        this.rp = packet;
        this.meshed = false;
        this.hopsLeftIndex = 0;
        this.meshIndex = 0;
        this.origLen = 8;
        this.destLen = 8;
        this.destAddrIndex = 0;
        this.origAddrIndex = 0;
        this.bCast = false;
        this.bCastIndex = 0;
        this.fragged = false;
        this.fragOffsetIndex = 0;
        this.fragSizeIndex = 0;
        this.fragTagIndex = 0;
        this.extendedProtocol = false;
        this.lppPayloadSize = 0;
        this.lppPayloadOffset = 0;
        this.protocolDispatchIndex = 0;
        this.protocolIndex = 0;
        this.parseIndex = 0;
        this.parse();
    }

    private void parse_fragment(byte dispatch) {
        this.fragged = true;
        short s = (short)(this.parseIndex - 1);
        this.fragSizeIndex = s;
        this.fragIndex = s;
        ++this.parseIndex;
        this.fragTagIndex = this.parseIndex++;
        ++this.parseIndex;
        if ((dispatch & 0xFFFFFFE0) == -32) {
            this.fragOffsetIndex = this.parseIndex++;
        }
        this.parse();
    }

    void parse_mesh(byte dispatch) {
        this.meshed = true;
        this.origLen = (dispatch & 0x20) == dispatch ? 2 : 8;
        this.destLen = (dispatch & 0x10) == dispatch ? 2 : 8;
        this.hopsLeftIndex = this.parseIndex - 1;
        if ((dispatch & 0xF) == 15) {
            this.extendedHops = true;
            ++this.parseIndex;
        }
        this.origAddrIndex = this.parseIndex;
        this.parseIndex += this.origLen;
        this.destAddrIndex = this.parseIndex;
        this.parseIndex += this.destLen;
        this.parse();
    }

    private void parse_broadcast(byte dispatch) {
        this.bCast = true;
        this.bCastIndex = this.parseIndex++;
        this.parse();
    }

    private void parse_esc(byte dispatch) {
        this.extendedProtocol = true;
        this.protocolDispatchIndex = this.parseIndex - 1;
        this.protocolIndex = this.parseIndex++;
    }

    private void parse_family(byte dispatch) {
        this.extendedProtocol = false;
        this.protocolIndex = this.protocolDispatchIndex = this.parseIndex - 1;
    }

    private void parse() {
        byte dispatch;
        if (this.rp.getLength() == 0) {
            return;
        }
        if (((dispatch = this.rp.getMACPayloadAt(this.parseIndex++)) & 0xFFFFFFC0) == -64) {
            this.parse_fragment(dispatch);
        } else if ((dispatch & 0xFFFFFF80) == -128) {
            this.parse_mesh(dispatch);
        } else if (dispatch == 80) {
            this.parse_broadcast(dispatch);
        } else if (dispatch == 127) {
            this.parse_esc(dispatch);
        } else {
            this.parse_family(dispatch);
        }
        this.lppPayloadOffset = this.rp.getPayloadOffset() + this.parseIndex;
        this.lppPayloadSize = this.rp.getMACPayloadLength() - this.getHeaderLength();
    }

    private void writeMeshHeader(LowPanHeader lph) {
        if (lph.getOutgoingHops() > 14) {
            byte meshByte = -113;
            this.rp.setMACPayloadAt(this.parseIndex++, meshByte);
            this.rp.setMACPayloadAt(this.parseIndex++, (byte)(lph.getOutgoingHops() & 0xFF));
        } else {
            byte meshByte = (byte)(0x80 | lph.getOutgoingHops() & 0xF);
            this.rp.setMACPayloadAt(this.parseIndex++, meshByte);
        }
        this.origAddrIndex = this.parseIndex;
        this.rp.setMACPayloadBigEndLongAt(this.origAddrIndex, lph.getOutgoingOriginatorAddress());
        this.parseIndex += 8;
        this.destAddrIndex = this.parseIndex;
        this.rp.setMACPayloadBigEndLongAt(this.destAddrIndex, lph.getOutgoingDestinationAddress());
        this.parseIndex += 8;
    }

    private void writeBroadcastHeader(LowPanHeader lph) {
        this.rp.setMACPayloadAt(this.parseIndex++, (byte)80);
        this.bCastIndex = this.parseIndex;
        this.rp.setMACPayloadAt(this.parseIndex++, (byte)(lph.getOutgoingBCastSeqNo() & 0xFF));
    }

    private void writeFragmentHeader(LowPanHeader lph) {
        byte b = 0;
        switch (lph.getOutgoingFragType()) {
            case 0: {
                return;
            }
            case 2: {
                b = -64;
                break;
            }
            case 1: 
            case 3: {
                b = -32;
            }
        }
        b = (byte)(b | (byte)(lph.getOutgoingFragSize() >> 8 & 7));
        this.fragIndex = this.fragSizeIndex = this.parseIndex;
        this.rp.setMACPayloadAt(this.parseIndex++, b);
        this.rp.setMACPayloadAt(this.parseIndex++, (byte)(lph.getOutgoingFragSize() & 0xFF));
        this.fragTagIndex = this.parseIndex;
        this.rp.setMACPayloadBigEndShortAt(this.parseIndex++, (int)((short)(lph.getOutgoingFragTag() & 0xFFFF)));
        ++this.parseIndex;
        if (lph.getOutgoingFragType() != 2) {
            this.fragOffsetIndex = this.parseIndex;
            this.rp.setMACPayloadAt(this.parseIndex++, lph.getOutgoingFragOffset());
        }
    }

    private void writeProtocolHeader(LowPanHeader lph) {
        if (lph.getProtocolFamily() == 127) {
            this.rp.setMACPayloadAt(this.parseIndex++, (byte)127);
            this.rp.setMACPayloadAt(this.parseIndex++, lph.getProtocolNo());
        } else {
            this.rp.setMACPayloadAt(this.parseIndex++, lph.getProtocolFamily());
        }
    }

    public void writeHeaderAndPayload(LowPanHeader lph, byte[] buffer, int start, int end) {
        this.parseIndex = 0;
        if (lph.isMeshed()) {
            this.writeMeshHeader(lph);
        }
        if (lph.isBCast()) {
            this.writeBroadcastHeader(lph);
        }
        if (lph.isFragged()) {
            this.writeFragmentHeader(lph);
        }
        this.writeProtocolHeader(lph);
        int payloadStart = this.rp.getPayloadOffset() + lph.getLength();
        int dataLength = end - start;
        int payloadSize = dataLength + lph.getLength();
        if (payloadSize < 102) {
            this.rp.setMACPayloadLength(payloadSize);
            System.arraycopy(buffer, start, this.rp.buffer, payloadStart, dataLength);
        } else {
            System.out.println("[lpp] Packet was too large to copy");
        }
    }

    public byte getHopsLeft() {
        byte hopsLeft = (byte)(this.rp.getMACPayloadAt(this.hopsLeftIndex) & 0xF);
        if (hopsLeft == 15) {
            return this.rp.getMACPayloadAt(this.hopsLeftIndex + 1);
        }
        return hopsLeft;
    }

    public void setHopsLeft(int hopsLeft) {
        if (this.extendedHops) {
            byte save = (byte)(this.rp.getMACPayloadAt(this.hopsLeftIndex) & 0xF0);
            this.rp.setMACPayloadAt(this.hopsLeftIndex, (byte)(save | 0xF));
            this.rp.setMACPayloadAt(this.hopsLeftIndex + 1, (byte)(hopsLeft & 0xFF));
        } else {
            byte save = (byte)(this.rp.getMACPayloadAt(this.hopsLeftIndex) & 0xF0);
            this.rp.setMACPayloadAt(this.hopsLeftIndex, (byte)(save | hopsLeft));
        }
    }

    public int getDestLen() {
        return this.destLen;
    }

    public void setDestLen(int destLen) {
        this.destLen = destLen;
    }

    public int getOrigLen() {
        return this.origLen;
    }

    public void setOrigLen(int origLen) {
        this.origLen = origLen;
    }

    public long getOriginatorAddress() {
        if (this.origLen == 2) {
            return this.rp.getMACPayloadBigEndShortAt(this.origAddrIndex);
        }
        return this.rp.getMACPayloadBigEndLongAt(this.origAddrIndex);
    }

    public void setOriginatorAddress(long origAddr) {
        if (this.origLen == 2) {
            this.rp.setMACPayloadBigEndShortAt(this.origAddrIndex, (int)((short)(origAddr & 0xFFFFL)));
        } else {
            this.rp.setMACPayloadBigEndLongAt(this.origAddrIndex, origAddr);
        }
    }

    public long getFDestinationAddress() {
        if (this.destLen == 2) {
            return this.rp.getMACPayloadBigEndShortAt(this.destAddrIndex);
        }
        return this.rp.getMACPayloadBigEndLongAt(this.destAddrIndex);
    }

    public void setFDestinationAddress(long destAddr) {
        if (this.destLen == 2) {
            this.rp.setMACPayloadBigEndShortAt(this.destAddrIndex, (int)((short)(destAddr & 0xFFFFL)));
        } else {
            this.rp.setMACPayloadBigEndLongAt(this.destAddrIndex, destAddr);
        }
    }

    public int getBCastSeqNo() {
        if (this.isBCast()) {
            return this.rp.getMACPayloadAt(this.bCastIndex) & 0xFF;
        }
        return 0;
    }

    public void setBCastSeqNo(int bCastSeqNo) {
        this.rp.setMACPayloadAt(this.bCastIndex, (byte)(bCastSeqNo & 0xFF));
    }

    public void setFragType(byte type) {
        byte save = (byte)(this.rp.getMACPayloadAt(this.fragIndex) & 7);
        save = (byte)(save | type & 0xE0);
        this.rp.setMACPayloadAt(this.fragTagIndex, save);
    }

    public byte getFragType() {
        byte fragTag = (byte)(this.rp.getMACPayloadAt(this.fragIndex) & 0xE0);
        return fragTag;
    }

    public void setFragTag(short tag) {
        this.rp.setMACPayloadBigEndShortAt(this.fragTagIndex, (int)tag);
    }

    public short getFragTag() {
        return (short)(this.rp.getMACPayloadBigEndShortAt(this.fragTagIndex) & 0xFFFF);
    }

    public void setFragSize(short size) {
        byte save = (byte)(this.rp.getMACPayloadAt(this.fragSizeIndex) & 0xF8);
        save = (byte)(save | size >> 8 & 7);
        this.rp.setMACPayloadAt(this.fragSizeIndex, save);
        this.rp.setMACPayloadAt(this.fragSizeIndex + 1, (byte)(size & 0xFF));
    }

    public short getFragSize() {
        int fragSize = 0;
        int val = this.rp.getMACPayloadAt(this.fragSizeIndex) & 0xFF;
        fragSize = (val & 7) << 8;
        return (short)((fragSize |= this.rp.getMACPayloadAt(this.fragSizeIndex + 1) & 0xFF) & 0xFFFF);
    }

    public byte getFragOff() {
        int fragOff = this.rp.getMACPayloadAt(this.fragOffsetIndex) & 0xFF;
        return (byte)(fragOff & 0xFF);
    }

    public void setFragOff(byte fragOff) {
        this.rp.setMACPayloadAt(this.fragOffsetIndex, fragOff);
    }

    public boolean isFirstFrag() {
        byte fragTag = (byte)(this.rp.getMACPayloadAt(this.fragIndex) & 0xE0);
        return fragTag == -64;
    }

    public byte getProtocolFamily() {
        byte pf = this.rp.getMACPayloadAt(this.protocolDispatchIndex);
        return pf;
    }

    public void setProtocolFamily(byte protocolFamily) {
        this.rp.setMACPayloadAt(this.protocolDispatchIndex, protocolFamily);
    }

    public byte getProtocol() {
        byte protocol = this.rp.getMACPayloadAt(this.protocolIndex);
        return protocol;
    }

    public void setProtocol(byte protocol) {
        this.rp.setMACPayloadAt(this.protocolIndex, protocol);
    }

    public void setProtocol(byte family, byte protocol) {
        this.setProtocolFamily(family);
        this.setProtocol(protocol);
    }

    public boolean isMeshed() {
        return this.meshed;
    }

    public void setMeshed(boolean meshed) {
        this.meshed = meshed;
    }

    public boolean isBCast() {
        return this.bCast;
    }

    public void setBCast(boolean bCast) {
        this.bCast = bCast;
    }

    public boolean isFragged() {
        return this.fragged;
    }

    public void setFragged(boolean fragged) {
        this.fragged = fragged;
    }

    public long getRPSourceAddress() {
        return this.rp.getSourceAddress();
    }

    public RadioPacket getRadioPacket() {
        return this.rp;
    }

    public void setRPDestinationAddress(long addr) {
        this.rp.setDestinationAddress(addr);
    }

    public void setRPSourceAddress(long addr) {
        this.rp.setSourceAddress(addr);
    }

    public int getPayloadSize() {
        return this.lppPayloadSize;
    }

    public void setPayloadSize(int payloadSize) {
        this.lppPayloadSize = payloadSize;
    }

    public int getHeaderLength() {
        int len = 0;
        if (this.isMeshed()) {
            len += 1 + this.destLen + this.origLen;
        }
        if (this.isBCast()) {
            len += 2;
        }
        if (this.isFragged()) {
            len += 5;
            if (this.isFirstFrag()) {
                --len;
            }
        }
        return len += this.isExtendedProtocol() ? 2 : 1;
    }

    public boolean isExtendedProtocol() {
        return this.extendedProtocol;
    }

    public void setExtendedProtocol(boolean extendedProtocol) {
        this.extendedProtocol = extendedProtocol;
    }

    public int getLppPayloadOffset() {
        return this.lppPayloadOffset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("LPP orig: ");
        sb.append(new IEEEAddress(this.getOriginatorAddress()).asDottedHex());
        sb.append(" fdest: ");
        sb.append(new IEEEAddress(this.getFDestinationAddress()).asDottedHex());
        sb.append(" hopsLeft: ");
        sb.append(this.getHopsLeft());
        sb.append(" ");
        sb.append(this.rp.toString());
        return sb.toString();
    }
}

