/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.util.Utils;
import java.util.Date;

public class LowPanStats {
    private long timestamp;
    protected int protocolCount;
    protected int protocolFamilyCount;
    protected int protocolHandlerMissing;
    protected int unicastsSent;
    protected int unicastsFragmented;
    protected int nonMeshPacketsSent;
    protected int meshPacketsSent;
    protected int packetsSent;
    protected int broadcastsSent;
    protected int broadcastsReceived;
    protected int meshBroadcastsSent;
    protected int meshBroadcastsReceived;
    protected int broadcastsFragmented;
    protected int packetsForwarded;
    protected int meshBroadcastsForwarded;
    protected int ttlExpired;
    protected int droppedBroadcasts;
    protected int broadcastsQueueFull;
    protected int meshPacketsReceived;
    protected int nonMeshPacketsReceived;
    protected int datagramsReassembled;
    protected int reassemblyExpired;
    protected int fragmentsReceived;
    protected int unicastsReceived;

    public LowPanStats() {
        this.timestamp = 0L;
        this.unicastsSent = 0;
        this.unicastsFragmented = 0;
        this.unicastsReceived = 0;
        this.broadcastsSent = 0;
        this.broadcastsReceived = 0;
        this.meshBroadcastsSent = 0;
        this.meshBroadcastsReceived = 0;
        this.broadcastsFragmented = 0;
        this.meshBroadcastsForwarded = 0;
        this.packetsSent = 0;
        this.packetsForwarded = 0;
        this.meshPacketsReceived = 0;
        this.meshPacketsSent = 0;
        this.nonMeshPacketsReceived = 0;
        this.nonMeshPacketsSent = 0;
        this.reassemblyExpired = 0;
        this.ttlExpired = 0;
        this.datagramsReassembled = 0;
        this.fragmentsReceived = 0;
        this.broadcastsQueueFull = 0;
        this.droppedBroadcasts = 0;
        this.protocolCount = 0;
        this.protocolFamilyCount = 0;
        this.protocolHandlerMissing = 0;
    }

    public LowPanStats(byte[] b) {
        int index = 0;
        this.timestamp = Utils.readLittleEndLong((byte[])b, (int)index);
        this.protocolCount = Utils.readLittleEndInt((byte[])b, (int)(index += 8));
        this.protocolFamilyCount = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.protocolHandlerMissing = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.unicastsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.unicastsFragmented = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.nonMeshPacketsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.meshPacketsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.packetsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.broadcastsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.broadcastsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.meshBroadcastsSent = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.meshBroadcastsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.broadcastsFragmented = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.packetsForwarded = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.meshBroadcastsForwarded = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.ttlExpired = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.droppedBroadcasts = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.broadcastsQueueFull = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.meshPacketsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.nonMeshPacketsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.datagramsReassembled = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.reassemblyExpired = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.fragmentsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        this.unicastsReceived = Utils.readLittleEndInt((byte[])b, (int)(index += 4));
        index += 4;
    }

    public int getUnicastsSent() {
        return this.unicastsSent;
    }

    public int getUnicastsFragmented() {
        return this.unicastsFragmented;
    }

    public int getUnicastsReceived() {
        return this.unicastsReceived;
    }

    public int getBroadcastsSent() {
        return this.broadcastsSent;
    }

    public int getBroadcastsFragmented() {
        return this.broadcastsFragmented;
    }

    public int getBroadcastsReceived() {
        return this.broadcastsReceived;
    }

    public int getPacketsSent() {
        return this.packetsSent;
    }

    public int getPacketsForwarded() {
        return this.packetsForwarded;
    }

    public int getBroadcastsForwarded() {
        return this.meshBroadcastsForwarded;
    }

    public int getMeshPacketsReceived() {
        return this.meshPacketsReceived;
    }

    public int getMeshPacketsSent() {
        return this.meshPacketsSent;
    }

    public int getNonMeshPacketsReceived() {
        return this.nonMeshPacketsReceived;
    }

    public int getNonMeshPacketsSent() {
        return this.nonMeshPacketsSent;
    }

    public int getReassemblyExpired() {
        return this.reassemblyExpired;
    }

    public int getTTLExpired() {
        return this.ttlExpired;
    }

    public int getDatagramsReassembled() {
        return this.datagramsReassembled;
    }

    public int getFragmentsReceived() {
        return this.fragmentsReceived;
    }

    public int getProtocolCount() {
        return this.protocolCount;
    }

    public int getProtocolFamilyCount() {
        return this.protocolFamilyCount;
    }

    public int getProtocolHandlerMissing() {
        return this.protocolHandlerMissing;
    }

    public int getDroppedBroadcasts() {
        return this.droppedBroadcasts;
    }

    public int getDroppedOwnBroadcasts() {
        return this.broadcastsQueueFull;
    }

    public LowPanStats clone() {
        LowPanStats newObj = new LowPanStats();
        newObj.timestamp = System.currentTimeMillis();
        newObj.unicastsSent = this.unicastsSent;
        newObj.unicastsFragmented = this.unicastsFragmented;
        newObj.unicastsReceived = this.unicastsReceived;
        newObj.broadcastsSent = this.broadcastsSent;
        newObj.broadcastsFragmented = this.broadcastsFragmented;
        newObj.broadcastsReceived = this.broadcastsReceived;
        newObj.packetsSent = this.packetsSent;
        newObj.packetsForwarded = this.packetsForwarded;
        newObj.meshBroadcastsSent = this.meshBroadcastsSent;
        newObj.meshBroadcastsReceived = this.meshBroadcastsReceived;
        newObj.meshBroadcastsForwarded = this.meshBroadcastsForwarded;
        newObj.meshPacketsReceived = this.meshPacketsReceived;
        newObj.meshPacketsSent = this.meshPacketsSent;
        newObj.nonMeshPacketsReceived = this.nonMeshPacketsReceived;
        newObj.nonMeshPacketsSent = this.nonMeshPacketsSent;
        newObj.reassemblyExpired = this.reassemblyExpired;
        newObj.ttlExpired = this.ttlExpired;
        newObj.droppedBroadcasts = this.droppedBroadcasts;
        newObj.broadcastsQueueFull = this.broadcastsQueueFull;
        newObj.datagramsReassembled = this.datagramsReassembled;
        newObj.fragmentsReceived = this.fragmentsReceived;
        newObj.protocolCount = this.protocolCount;
        newObj.protocolFamilyCount = this.protocolFamilyCount;
        newObj.protocolHandlerMissing = this.protocolHandlerMissing;
        return newObj;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[104];
        int index = 0;
        Utils.writeLittleEndLong((byte[])b, (int)index, (long)this.timestamp);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 8), (int)this.protocolCount);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.protocolFamilyCount);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.protocolHandlerMissing);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.unicastsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.unicastsFragmented);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.nonMeshPacketsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.meshPacketsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.packetsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.broadcastsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.broadcastsReceived);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.meshBroadcastsSent);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.meshBroadcastsReceived);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.broadcastsFragmented);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.packetsForwarded);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.meshBroadcastsForwarded);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.ttlExpired);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.droppedBroadcasts);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.broadcastsQueueFull);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.meshPacketsReceived);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.nonMeshPacketsReceived);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.datagramsReassembled);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.reassemblyExpired);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.fragmentsReceived);
        Utils.writeLittleEndInt((byte[])b, (int)(index += 4), (int)this.unicastsReceived);
        index += 4;
        return b;
    }

    public String toString() {
        String s = "Timestamp: " + new Date(this.timestamp).toString() + "\n";
        s = s + "unicastsSent: " + this.unicastsSent + "\n";
        s = s + "unicastsFragmented: " + this.unicastsFragmented + "\n";
        s = s + "unicastsReceived: " + this.unicastsReceived + "\n";
        s = s + "broadcastsSent: " + this.broadcastsSent + "\n";
        s = s + "broadcastsFragmented: " + this.broadcastsFragmented + "\n";
        s = s + "broadcastsReceived: " + this.broadcastsReceived + "\n";
        s = s + "meshBroadcastsSent: " + this.meshBroadcastsSent + "\n";
        s = s + "meshBroadcastsReceived: " + this.meshBroadcastsReceived + "\n";
        s = s + "meshBroadcastsForwarded: " + this.meshBroadcastsForwarded + "\n";
        s = s + "packetsSent: " + this.packetsSent + "\n";
        s = s + "packetsForwarded: " + this.packetsForwarded + "\n";
        s = s + "nonMeshPacketsSent: " + this.nonMeshPacketsSent + "\n";
        s = s + "nonMeshPacketsReceived: " + this.nonMeshPacketsReceived + "\n";
        s = s + "meshPacketsSent: " + this.meshPacketsSent + "\n";
        s = s + "meshPacketsReceived: " + this.meshPacketsReceived + "\n";
        s = s + "reassemblyExpired: " + this.reassemblyExpired + "\n";
        s = s + "datagramsReassembled: " + this.datagramsReassembled + "\n";
        s = s + "fragmentsRecevied: " + this.fragmentsReceived + "\n";
        s = s + "ttlExpired: " + this.ttlExpired + "\n";
        s = s + "broadcastQueueFull: " + this.broadcastsQueueFull + "\n";
        s = s + "droppedBroadcasts: " + this.droppedBroadcasts + "\n";
        s = s + "protocolCount: " + this.protocolCount + "\n";
        s = s + "protocolfamilyCount: " + this.protocolFamilyCount + "\n";
        s = s + "protocolHandlerMissing: " + this.protocolHandlerMissing + "\n";
        return s;
    }
}

