/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPolicy;
import com.sun.spot.util.Utils;

public class MeshRouterDaemon {
    private static boolean meshOn = false;

    public static void main(String[] args) {
        new MeshRouterDaemon(args);
    }

    private MeshRouterDaemon(String[] args) {
        if (args.length == 0) {
            if (!meshOn) {
                this.forceMeshOn();
            }
            this.waitForEver();
        } else if (this.isMeshingOptionSet()) {
            this.forceMeshOn();
            meshOn = true;
        }
    }

    private synchronized void waitForEver() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isMeshingOptionSet() {
        return Utils.isOptionSelected((String)"spot.mesh.enable", (boolean)false);
    }

    private void forceMeshOn() {
        System.out.println("[enabling mesh routing]");
        IRadioPolicyManager radioPolicyManager = RadioFactory.getRadioPolicyManager();
        ConnectionID connectionID = new ConnectionID();
        radioPolicyManager.registerConnection((IConnectionID)connectionID);
        radioPolicyManager.policyHasChanged((IConnectionID)connectionID, RadioPolicy.ON);
        LowPan.getInstance();
    }
}

