/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IPacketQualityListener;
import com.sun.spot.peripheral.radio.IRadioPacketDispatcher;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Queue;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class RadioPacketDispatcher
implements IRadioPacketDispatcher {
    private static final int MAX_PACKETS_QUEUED = 200;
    private ILowPan lowPan;
    private static IRadioPacketDispatcher theRPD;
    private IRadioPolicyManager rpm;
    private MACDescriptor[] macList;
    private Hashtable macTable = new Hashtable();
    private PacketQualityForwarderThread packetFwdThread;
    private Vector packetListener;
    private Queue packetQueue;

    public static synchronized IRadioPacketDispatcher getInstance() {
        if (theRPD == null) {
            theRPD = new RadioPacketDispatcher(RadioFactory.getI802_15_4_MACs(), RadioFactory.getRadioPolicyManager());
            RadioFactory.setProperty((String)"IEEE_ADDRESS", (String)new IEEEAddress(RadioFactory.getRadioPolicyManager().getIEEEAddress()).asDottedHex());
        }
        return theRPD;
    }

    private RadioPacketDispatcher(I802_15_4_MAC[] macs, IRadioPolicyManager radioPolicyManager) {
        this.macList = new MACDescriptor[macs.length];
        this.packetListener = new Vector();
        this.packetQueue = new Queue();
        this.rpm = radioPolicyManager;
        for (int i = 0; i < macs.length; ++i) {
            this.macList[i] = new MACDescriptor(macs[i], macs[i].mlmeGet(368));
        }
    }

    public void registerPacketQualityListener(IPacketQualityListener packetListener) {
        this.packetListener.addElement(packetListener);
        if (this.packetFwdThread == null) {
            this.packetFwdThread = new PacketQualityForwarderThread();
            this.packetFwdThread.start();
        }
    }

    public void deregisterPacketQualityListener(IPacketQualityListener listener) {
        this.packetListener.removeElement(listener);
        if (this.packetListener.isEmpty()) {
            this.packetFwdThread = null;
        }
    }

    public void sendBroadcast(RadioPacket rp) throws NoAckException, ChannelBusyException {
        for (int i = 0; i < this.macList.length; ++i) {
            rp.setDestinationPanID((int)this.rpm.getPanId());
            rp.setSourceAddress(this.macList[i].getOurAddress());
            int result = this.macList[i].getMacDevice().mcpsDataRequest(rp);
            if (result == 0) continue;
            if (result == 233) {
                throw new NoAckException("No ack");
            }
            if (result != 225) continue;
            throw new ChannelBusyException("Channel busy");
        }
    }

    public void sendPacket(RadioPacket rp) throws NoAckException, ChannelBusyException {
        MACDescriptor macDesc = (MACDescriptor)this.macTable.get(new Long(rp.getDestinationAddress()));
        if (macDesc == null) {
            this.sendBroadcast(rp);
        } else {
            rp.setDestinationPanID((int)this.rpm.getPanId());
            rp.setSourceAddress(macDesc.getOurAddress());
            int result = macDesc.getMacDevice().mcpsDataRequest(rp);
            if (result != 0) {
                if (result == 233) {
                    throw new NoAckException("No ack");
                }
                if (result == 225) {
                    throw new ChannelBusyException("Channel busy");
                }
            }
        }
        if (!this.packetListener.isEmpty() && this.packetQueue.size() < 200) {
            this.packetQueue.put((Object)rp);
        }
    }

    public synchronized void initialize(ILowPan lowPanLayer) {
        this.lowPan = lowPanLayer;
        for (int i = 0; i < this.macList.length; ++i) {
            DispatcherThread dispatcherThread = new DispatcherThread(this.macList[i]);
            RadioFactory.setAsDaemonThread((Thread)dispatcherThread);
            dispatcherThread.start();
        }
    }

    private class PacketQualityForwarderThread
    extends Thread {
        PacketQualityForwarderThread() {
            super("PacketQualityForwarder");
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block0: while (true) {
                rp = null;
                while (rp == null) {
                    rp = (RadioPacket)RadioPacketDispatcher.access$300(RadioPacketDispatcher.this).get();
                }
                if (RadioPacketDispatcher.access$200(RadioPacketDispatcher.this).isEmpty()) continue;
                en = RadioPacketDispatcher.access$200(RadioPacketDispatcher.this).elements();
                while (true) {
                    if (en.hasMoreElements()) ** break;
                    continue block0;
                    ((IPacketQualityListener)en.nextElement()).notifyPacket(rp.getSourceAddress(), rp.getDestinationAddress(), rp.getRssi(), rp.getCorr(), rp.getLinkQuality(), rp.getLength());
                }
                break;
            }
        }
    }

    private class MACDescriptor {
        private I802_15_4_MAC macDevice;
        private long ourAddress;

        public MACDescriptor(I802_15_4_MAC mac, long addr) {
            this.setMacDevice(mac);
            this.setOurAddress(addr);
        }

        public I802_15_4_MAC getMacDevice() {
            return this.macDevice;
        }

        public void setMacDevice(I802_15_4_MAC macDevice) {
            this.macDevice = macDevice;
        }

        public long getOurAddress() {
            return this.ourAddress;
        }

        public void setOurAddress(long ourAddress) {
            this.ourAddress = ourAddress;
        }
    }

    private class DispatcherThread
    extends Thread {
        MACDescriptor macDesc;

        DispatcherThread(MACDescriptor desc) {
            super("RadioPacketDispatcher:" + new IEEEAddress(desc.getOurAddress()).asDottedHex());
            this.macDesc = desc;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        RadioPacket rp = RadioPacket.getDataPacket();
                        this.macDesc.getMacDevice().mcpsDataIndication(rp);
                        RadioPacketDispatcher.this.macTable.put(new Long(rp.getSourceAddress()), this.macDesc);
                        RadioPacketDispatcher.this.lowPan.receive(rp);
                        if (RadioPacketDispatcher.this.packetListener.isEmpty() || RadioPacketDispatcher.this.packetQueue.size() >= 200) continue;
                        RadioPacketDispatcher.this.packetQueue.put((Object)rp);
                    }
                }
                catch (Exception e) {
                    if (e instanceof NullPointerException) {
                        System.out.println("[RadioPacketDispatcher] Packet received while LowPan uninitialized");
                        e.printStackTrace();
                        continue;
                    }
                    if (e instanceof IOException) continue;
                    System.out.println("[RadioPacketDispatcher] \nException processing packet");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

