/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.ConnectionState;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadioProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Utils;
import java.util.Hashtable;

public abstract class RadioProtocolManager
implements IRadioProtocolManager {
    static final byte CTRL_NEW_CONN = 1;
    IRadioPolicyManager radioPolicyManager;
    ILowPan lowpan;
    Hashtable connectionIDTable = new Hashtable();
    ConnectionID needle = new ConnectionID(0L, 0, 0);

    RadioProtocolManager(ILowPan lowpan, IRadioPolicyManager radioPolicyManager) {
        this.lowpan = lowpan;
        this.radioPolicyManager = radioPolicyManager;
    }

    public IncomingData receivePacket(ConnectionID cid) {
        ConnectionState cs = (ConnectionState)this.connectionIDTable.get(cid);
        if (cs == null) {
            return null;
        }
        return cs.getQueuedPacket();
    }

    public IncomingData receivePacket(ConnectionID cid, long timeout) {
        ConnectionState cs = (ConnectionState)this.connectionIDTable.get(cid);
        if (cs == null) {
            return null;
        }
        return cs.getQueuedPacket(timeout);
    }

    public boolean packetsAvailable(ConnectionID connectionID) {
        ConnectionState cs = (ConnectionState)this.connectionIDTable.get(connectionID);
        return cs.packetsAvailable();
    }

    public synchronized void closeConnection(ConnectionID cidToClose) {
        ConnectionState cs = (ConnectionState)this.connectionIDTable.get(cidToClose);
        if (cs == null) {
            throw new IllegalArgumentException("Attempt to close unknown connection " + cidToClose.toString());
        }
        if (cs.close()) {
            this.connectionIDTable.remove(cidToClose);
            this.log("Removing: " + cidToClose.toString());
        }
    }

    public synchronized ConnectionID addOutputConnection(long macAddress, byte portNo) {
        return this.addConnection(false, new ConnectionID(macAddress, portNo, 0));
    }

    protected ConnectionID addConnection(boolean canReceive, ConnectionID cid) {
        if (cid.portNo == 0) {
            cid.portNo = (byte)32;
            while (this.connectionIDTable.containsKey(cid)) {
                cid.portNo = (byte)(cid.portNo + 1);
                if (cid.portNo != 0) continue;
                throw new SpotFatalException("Run out of port numbers for remote address " + new IEEEAddress(cid.getMacAddress()));
            }
        }
        if (this.connectionIDTable.containsKey(cid)) {
            throw new IllegalArgumentException("Attempt to open connection twice for " + cid.toString());
        }
        ConnectionState cs = ConnectionState.newInstance(canReceive, cid);
        this.connectionIDTable.put(cs.id, cs);
        this.log(" Adding: " + cid.toString());
        return cs.id;
    }

    protected ConnectionState getConnectionState(long macAddress, int connectionType, byte portNumber) {
        this.needle.macAddress = macAddress;
        this.needle.connectionType = connectionType;
        this.needle.portNo = portNumber;
        return (ConnectionState)this.connectionIDTable.get(this.needle);
    }

    protected abstract String getName();

    private void log(String message) {
        if (Utils.isOptionSelected((String)"spot.log.connections", (boolean)false)) {
            System.out.println("[" + this.getName() + "]" + message);
        }
    }

    public synchronized ConnectionID addInputConnection(long macAddress, byte portNo) {
        return this.addConnection(true, new ConnectionID(macAddress, portNo, 1));
    }
}

