/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.interisolate.InterIsolateServer;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.radio.BroadcastConnectionState;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.ConnectionState;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadioProtocolManager;
import com.sun.spot.peripheral.radio.IRadiogramProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioProtocolManager;
import com.sun.spot.peripheral.radio.proxy.IRadioServerContext;
import com.sun.spot.peripheral.radio.proxy.ProxyRadiogramProtocolManager;

public class RadiogramProtocolManager
extends RadioProtocolManager
implements IProtocolManager,
IRadiogramProtocolManager {
    public static final byte PROTOCOL_NUMBER = 105;
    public static final String PROTOCOL_NAME = "radiogram";
    private static IRadiogramProtocolManager theInstance;

    public static void main(String[] args) {
        InterIsolateServer.run((String)"RADIOGRAM_SERVER", (Object)new IRadioServerContext(){

            public IRadioProtocolManager getRadioProtocolManager() {
                return RadiogramProtocolManager.getInstance();
            }
        });
    }

    public static synchronized IRadiogramProtocolManager getInstance() {
        if (theInstance == null) {
            theInstance = RadioFactory.isMasterIsolate() ? new RadiogramProtocolManager() : new ProxyRadiogramProtocolManager(105, PROTOCOL_NAME);
        }
        return theInstance;
    }

    RadiogramProtocolManager(ILowPan lowpan, IRadioPolicyManager radioPolicyManager) {
        super(lowpan, radioPolicyManager);
    }

    public RadiogramProtocolManager() {
        this(LowPan.getInstance(), RadioFactory.getRadioPolicyManager());
        this.lowpan.registerProtocol((byte)105, this);
    }

    public long send(ConnectionID cid, long toAddress, byte[] payload, int length) throws NoAckException, ChannelBusyException, NoRouteException {
        if (!cid.canSend()) {
            throw new IllegalArgumentException(cid.toString() + " cannot be used for sending");
        }
        if (toAddress == 0L) {
            throw new IllegalArgumentException("Cannot send to address 0");
        }
        payload[0] = cid.getPortNo();
        if (cid.isBroadcast()) {
            return this.lowpan.sendBroadcast((byte)105, payload, 0, length, cid.getMaxBroadcastHops());
        }
        return this.lowpan.send((byte)127, (byte)105, toAddress, payload, 0, length);
    }

    public synchronized void processIncomingData(byte[] payload, LowPanHeaderInfo headerInfo) {
        byte portNumber = payload[0];
        ConnectionState destinationCS = this.getConnectionState(0L, 2, portNumber);
        if (destinationCS == null) {
            destinationCS = this.getConnectionState(headerInfo.originator, 1, portNumber);
        }
        if (destinationCS != null) {
            destinationCS.addToQueue(new IncomingData(payload, headerInfo));
        }
    }

    public String getName() {
        return PROTOCOL_NAME;
    }

    public synchronized ConnectionID addServerConnection(byte portNo) {
        return this.addConnection(true, new ConnectionID(0L, portNo, 2));
    }

    public synchronized ConnectionID addBroadcastConnection(byte portNo) {
        ConnectionID cid = new ConnectionID(-1L, portNo, 3);
        BroadcastConnectionState foundState = (BroadcastConnectionState)this.connectionIDTable.get(cid);
        if (foundState != null) {
            foundState.incrementReferenceCount();
            return cid;
        }
        return this.addConnection(false, cid);
    }

    int getNumberOfEntriesInConnectionStateTable() {
        return this.connectionIDTable.size();
    }
}

