/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.interisolate.InterIsolateServer;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.ConnectionState;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadioProtocolManager;
import com.sun.spot.peripheral.radio.IRadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioOffException;
import com.sun.spot.peripheral.radio.RadioProtocolManager;
import com.sun.spot.peripheral.radio.RetransmitBuffer;
import com.sun.spot.peripheral.radio.RetransmitTimer;
import com.sun.spot.peripheral.radio.proxy.IRadioServerContext;
import com.sun.spot.peripheral.radio.proxy.ProxyRadiostreamProtocolManager;
import com.sun.spot.util.Debug;
import com.sun.spot.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class RadiostreamProtocolManager
extends RadioProtocolManager
implements IProtocolManager,
IRadiostreamProtocolManager {
    public static final byte PROTOCOL_NUMBER = 104;
    public static final String PROTOCOL_NAME = "radiostream";
    private static IRadiostreamProtocolManager theInstance;
    static final int NUMBER_OF_RETRIES = 3;
    static final byte CTRL_ACK = 2;
    static final byte CTRL_ACK_REQUIRED = 4;
    static int RETRANSMIT_TIMEOUT;
    private Timer retransScheduler = new Timer();
    private Queue inputQueue = new Queue();
    private InputHandler inputHandler = new InputHandler();

    public static void main(String[] args) {
        InterIsolateServer.run((String)"RADIOSTREAM_SERVER", (Object)new IRadioServerContext(){

            public IRadioProtocolManager getRadioProtocolManager() {
                return RadiostreamProtocolManager.getInstance();
            }
        });
    }

    public static synchronized IRadiostreamProtocolManager getInstance() {
        if (theInstance == null) {
            theInstance = RadioFactory.isMasterIsolate() ? new RadiostreamProtocolManager() : new ProxyRadiostreamProtocolManager(104, PROTOCOL_NAME);
        }
        return theInstance;
    }

    RadiostreamProtocolManager(ILowPan lowpan, IRadioPolicyManager radioPolicyManager) {
        super(lowpan, radioPolicyManager);
        RadioFactory.setAsDaemonThread((Thread)this.inputHandler);
        this.inputHandler.start();
    }

    public RadiostreamProtocolManager() {
        this(LowPan.getInstance(), RadioFactory.getRadioPolicyManager());
        this.lowpan.registerProtocol((byte)104, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long send(ConnectionID cid, long toAddress, byte[] payload, int length) throws NoAckException, ChannelBusyException, NoRouteException, NoMeshLayerAckException {
        if (!cid.canSend()) {
            throw new IllegalArgumentException(cid.toString() + " cannot be used for sending");
        }
        ConnectionState cs = (ConnectionState)this.connectionIDTable.get(cid);
        if (cs.status != 0) {
            System.out.println("[Radiostream] Discovered broken connection - reporting");
            cs.waitUntilNoRetransBuffers();
            return 0L;
        }
        ConnectionState connectionState = cs;
        synchronized (connectionState) {
            payload[0] = cid.getPortNo();
            int newSeq = (cs.lastOutgoingSeq + 1) % 256;
            if (cs.lastOutgoingSeq == -1) {
                payload[2] = 1;
                payload[1] = (byte)newSeq;
                newSeq = (newSeq + 1) % 256;
                this.sendData(cs, payload, 3);
                cs.waitUntilNoRetransBuffers();
            }
            payload[2] = 0;
            payload[1] = (byte)newSeq;
            this.sendData(cs, payload, length);
            cs.lastOutgoingSeq = newSeq;
        }
        return 0L;
    }

    public void waitForAllAcks(ConnectionID outConnectionId) throws NoAckException, ChannelBusyException, NoMeshLayerAckException, NoRouteException {
        ((ConnectionState)this.connectionIDTable.get(outConnectionId)).waitUntilNoRetransBuffers();
    }

    public void processIncomingData(byte[] payload, LowPanHeaderInfo headerInfo) {
        this.inputQueue.put((Object)new IncomingData(payload, headerInfo));
    }

    private void processIncomingData(IncomingData incoming) {
        byte portNumber = incoming.payload[0];
        if (this.isAck(incoming.payload)) {
            ConnectionState connectionState = this.getConnectionState(incoming.headerInfo.originator, 0, portNumber);
            connectionState.removeRetransBuffer(incoming.payload[1]);
        } else {
            ConnectionState connectionState = this.getConnectionState(incoming.headerInfo.originator, 1, portNumber);
            if (connectionState != null) {
                if (this.isAckRequested(incoming.payload)) {
                    this.sendAck(connectionState, incoming.payload[1]);
                }
                this.checkSequenceNumberAndEnqueue(connectionState, incoming);
            }
        }
    }

    private boolean isAck(byte[] payload) {
        return payload[2] == 2;
    }

    private boolean isAckRequested(byte[] payload) {
        return (payload[2] & 4) != 0;
    }

    private boolean isNewConnection(byte[] payload) {
        return (payload[2] & 1) != 0;
    }

    private void sendAck(ConnectionState connectionState, byte seqNum) {
        byte[] controlBuffer = new byte[]{connectionState.id.getPortNo(), seqNum, 2};
        try {
            this.lowpan.send((byte)127, (byte)104, connectionState.id.getMacAddress(), controlBuffer, 0, controlBuffer.length);
        }
        catch (NoRouteException ex) {
            Debug.print("[Radiostream] unable to send meshlayer ack due to no route exception.");
            ex.printStackTrace();
        }
        catch (ChannelBusyException ex) {
            Debug.print("[Radiostream] unable to send meshlayer ack due to channel busy.");
            ex.printStackTrace();
        }
    }

    public String getName() {
        return PROTOCOL_NAME;
    }

    void checkSequenceNumberAndEnqueue(ConnectionState connectionState, IncomingData incomingData) {
        int expectedSeq;
        int receivedSeq = incomingData.payload[1] & 0xFF;
        boolean newConnectionRequested = this.isNewConnection(incomingData.payload);
        int previousSequenceNumber = connectionState.lastIncomingSeq;
        if (newConnectionRequested || previousSequenceNumber == -1) {
            expectedSeq = receivedSeq;
            connectionState.lastIncomingSeq = receivedSeq;
            connectionState.emptyReorderTable();
        } else {
            expectedSeq = (previousSequenceNumber + 1) % 256;
        }
        if (receivedSeq != previousSequenceNumber && !newConnectionRequested) {
            if (expectedSeq == receivedSeq) {
                do {
                    connectionState.addToQueue(incomingData);
                } while ((incomingData = (IncomingData)connectionState.reorderTable.remove(expectedSeq = (expectedSeq + 1) % 256)) != null);
                connectionState.lastIncomingSeq = expectedSeq - 1;
            } else {
                connectionState.reorderTable.put(receivedSeq, (Object)incomingData);
            }
        }
    }

    private void sendData(ConnectionState cs, byte[] payload, int length) {
        RetransmitBuffer rb = new RetransmitBuffer(payload, length, 3);
        this.transmitWithRetries(rb, cs);
    }

    void setRadioPolicyManager(IRadioPolicyManager manager) {
        this.radioPolicyManager = manager;
    }

    void retransmit(RetransmitBuffer rb, ConnectionState cs, int conStat) {
        byte seqNum = rb.buffer[1];
        if (rb.retransCounter == 0) {
            cs.status = conStat;
            cs.removeRetransBuffer(seqNum);
        } else {
            --rb.retransCounter;
            this.transmitWithRetries(rb, cs);
        }
    }

    private void transmitWithRetries(RetransmitBuffer rb, ConnectionState cs) {
        byte seqNum = rb.buffer[1];
        try {
            boolean wasSent;
            if (this.isAckRequested(rb.buffer)) {
                if (!this.radioPolicyManager.isRadioReceiverOn()) {
                    throw new RadioOffException("Attempt to perform multihop send with radio receiver off");
                }
                rb.retransmitTimer = new RetransmitTimer(seqNum, cs, this);
                this.retransScheduler.schedule((TimerTask)rb.retransmitTimer, RETRANSMIT_TIMEOUT);
            }
            if (!(wasSent = this.lowpan.send((byte)127, (byte)104, cs.id.getMacAddress(), rb.buffer, 0, rb.buffer.length, !this.isAckRequested(rb.buffer)))) {
                rb.buffer[2] = (byte)(rb.buffer[2] | 4);
                cs.addRetransBuffer(seqNum, rb);
                this.transmitWithRetries(rb, cs);
            }
        }
        catch (NoRouteException ex) {
            if (rb.retransmitTimer != null) {
                rb.retransmitTimer.cancel();
            }
            Debug.print("[Radiostream] transmit: NoRouteException caught. Trying to retransmit");
            this.retransmit(rb, cs, 3);
        }
        catch (ChannelBusyException ex) {
            if (rb.retransmitTimer != null) {
                rb.retransmitTimer.cancel();
            }
            Debug.print("[Radiostream] transmit: ChannelBusyException caught. Trying to retransmit");
            this.retransmit(rb, cs, 4);
        }
    }

    static {
        RETRANSMIT_TIMEOUT = 15000;
    }

    private class InputHandler
    extends Thread {
        public InputHandler() {
            super("RadiostreamInputHandler");
        }

        public void run() {
            while (true) {
                IncomingData incoming = (IncomingData)RadiostreamProtocolManager.this.inputQueue.get();
                try {
                    RadiostreamProtocolManager.this.processIncomingData(incoming);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

