/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.RadioPacket;

class ReassemblyBuffer {
    private byte[] controlBuffer;
    byte[] buffer;
    byte protocolFamily;
    byte protocolNumber;

    public ReassemblyBuffer(int length) {
        this.buffer = new byte[length];
        this.controlBuffer = new byte[length];
    }

    public boolean write(int offset, RadioPacket packet, int firstByte, int fragmentLength) {
        if (this.buffer.length < offset * 8 + fragmentLength) {
            return false;
        }
        for (int i = offset * 8; i < offset * 8 + fragmentLength; ++i) {
            if (this.controlBuffer[i] == 1) {
                return false;
            }
            this.controlBuffer[i] = 1;
        }
        System.arraycopy(packet.buffer, firstByte, this.buffer, offset * 8, fragmentLength);
        return true;
    }

    public boolean isComplete() {
        for (int i = 0; i < this.controlBuffer.length; ++i) {
            if (this.controlBuffer[i] != 0) continue;
            return false;
        }
        return true;
    }
}

