/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.ConnectionState;
import com.sun.spot.peripheral.radio.RadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.RetransmitBuffer;
import com.sun.spot.util.Debug;
import java.util.TimerTask;

public class RetransmitTimer
extends TimerTask {
    private byte seqNo;
    private RadiostreamProtocolManager spm;
    private ConnectionState cs;

    public RetransmitTimer(byte seqNo, ConnectionState cs, RadiostreamProtocolManager spm) {
        this.cs = cs;
        this.seqNo = seqNo;
        this.spm = spm;
    }

    public void run() {
        RetransmitBuffer rb = this.cs.getRetransBuffer(this.seqNo);
        if (rb != null) {
            Debug.print("[Radiostream] RetransmitTimer expired for " + this.cs + " seq=" + this.seqNo + " at " + System.currentTimeMillis());
            this.spm.retransmit(rb, this.cs, 1);
        } else {
            Debug.print("[Radiostream] RetransmitTimer expired for " + this.cs + " seq=" + this.seqNo + " with no RetransmitBuffer at " + System.currentTimeMillis());
        }
    }
}

