/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp;

import com.sun.spot.peripheral.radio.mhrp.interfaces.Comparable;

public class SortedList {
    private LinkedListNode listHead = null;
    private LinkedListNode listTail = null;

    public void insertElement(Comparable newPayload) {
        if (this.listHead == null && this.listTail == null) {
            LinkedListNode nodeToInsert;
            this.listHead = nodeToInsert = new LinkedListNode(null, null, newPayload);
            this.listTail = nodeToInsert;
        } else {
            LinkedListNode currentNode = this.listTail;
            while (currentNode != null && currentNode.payload.compare(newPayload) >= 0) {
                currentNode = currentNode.prevNode;
            }
            if (currentNode == null) {
                LinkedListNode tempNode = this.listHead;
                tempNode.prevNode = this.listHead = new LinkedListNode(null, tempNode, newPayload);
            } else if (currentNode == this.listTail) {
                LinkedListNode tempNode = this.listTail;
                tempNode.nextNode = this.listTail = new LinkedListNode(tempNode, null, newPayload);
            } else {
                LinkedListNode nodeToInsert;
                currentNode.nextNode.prevNode = nodeToInsert = new LinkedListNode(currentNode, currentNode.nextNode, newPayload);
                currentNode.nextNode = nodeToInsert;
            }
        }
    }

    public Comparable removeFirstElement() {
        if (this.listHead != null) {
            LinkedListNode removedNode = this.listHead;
            this.listHead = removedNode.nextNode;
            if (this.listHead != null) {
                this.listHead.prevNode = null;
            } else {
                this.listTail = null;
            }
            return removedNode.payload;
        }
        return null;
    }

    public Comparable getFirstElement() {
        if (this.listHead != null) {
            return this.listHead.payload;
        }
        return null;
    }

    public Comparable removeElement(Comparable payloadToRemove) {
        LinkedListNode currentNode = this.listHead;
        Comparable returnedPayload = null;
        while (currentNode != null && currentNode.payload != payloadToRemove) {
            currentNode = currentNode.nextNode;
        }
        if (currentNode != null) {
            if (currentNode == this.listHead && currentNode == this.listTail) {
                this.listHead = null;
                this.listTail = null;
            } else if (currentNode == this.listHead) {
                currentNode.nextNode.prevNode = null;
                this.listHead = currentNode.nextNode;
            } else if (currentNode == this.listTail) {
                currentNode.prevNode.nextNode = null;
                this.listTail = currentNode.prevNode;
            } else {
                currentNode.prevNode.nextNode = currentNode.nextNode;
                currentNode.nextNode.prevNode = currentNode.prevNode;
            }
            returnedPayload = currentNode.payload;
        }
        return returnedPayload;
    }

    private class LinkedListNode {
        LinkedListNode nextNode = null;
        LinkedListNode prevNode = null;
        Comparable payload = null;

        public LinkedListNode(LinkedListNode prevNode, LinkedListNode nextNode, Comparable payload) {
            this.prevNode = prevNode;
            this.nextNode = nextNode;
            this.payload = payload;
        }
    }
}

