/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv;

import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.mhrp.aodv.Receiver;
import com.sun.spot.peripheral.radio.mhrp.aodv.Sender;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestTable;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingEntry;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingNeighbor;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingTable;
import com.sun.spot.peripheral.radio.mhrp.interfaces.IMHEventListener;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.RouteTable;
import com.sun.spot.peripheral.radio.routing.RoutingPolicyManager;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingManager;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import java.util.Enumeration;
import java.util.Vector;

public class AODVManager
implements IRoutingManager {
    private static String name = "AODVManager";
    private Sender sender;
    private Receiver receiver;
    private RoutingTable routingTable;
    private RequestTable requestTable;
    private Vector mhRouteListeners;
    private long sequenceNumber = 0L;
    private final Object sequenceLock = new Integer(0);
    private long ourAddress;
    private static AODVManager instance;
    private ILowPan lp;
    private int state = 0;
    private RoutingNeighbor advertizer;

    private AODVManager() {
        this.mhRouteListeners = new Vector();
    }

    public static synchronized AODVManager getInstance() {
        if (instance == null) {
            instance = new AODVManager();
        }
        return instance;
    }

    public synchronized void initialize(long ourAddress, ILowPan lowPan) {
        this.ourAddress = ourAddress;
        this.lp = lowPan;
    }

    public RouteTable getRoutingTable() {
        RouteTable rt = new RouteTable();
        Vector v = this.routingTable.getAllEntries();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            RoutingEntry re = (RoutingEntry)e.nextElement();
            rt.addEntry(new RouteInfo(re.key, re.nextHopMACAddress, re.hopCount));
        }
        return rt;
    }

    public RouteInfo getRouteInfo(long address) {
        RouteInfo info = this.routingTable.getNextHopInfo(address);
        if (info.nextHop != -1L && info.nextHop != address) {
            this.routingTable.freshenRoute(info.nextHop);
        }
        return info;
    }

    public boolean findRoute(long address, RouteEventClient eventClient, Object uniqueKey) throws NoRouteException {
        if (this.sender != null) {
            return this.sender.sendNewRREQ(address, eventClient, uniqueKey);
        }
        throw new NoRouteException("AODV Not running");
    }

    public boolean initiateRouteDiscovery(long address) {
        return this.sender.sendNewRREQ(address, null, null);
    }

    public boolean invalidateRoute(long originator, long destination) {
        this.routingTable.deactivateRoute(originator, destination);
        if (originator == this.ourAddress) {
            return true;
        }
        return this.sender.sendNewRERR(originator, destination);
    }

    public void registerEventListener(IMHEventListener listener) {
        this.mhRouteListeners.addElement(listener);
    }

    public void deregisterEventListener(IMHEventListener listener) {
        this.mhRouteListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSequenceNumber() {
        long returnedNumber;
        Object object = this.sequenceLock;
        synchronized (object) {
            if (this.sequenceNumber == 0xFFFFFFFL) {
                returnedNumber = this.sequenceNumber = 1L;
            } else {
                ++this.sequenceNumber;
                returnedNumber = this.sequenceNumber;
            }
        }
        return (int)returnedNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSequenceNumber(int givenNumber) {
        long returnedNumber;
        Object object = this.sequenceLock;
        synchronized (object) {
            returnedNumber = (long)givenNumber++ > 0xFFFFFFFL ? (this.sequenceNumber = 1L) : (this.sequenceNumber = (long)givenNumber);
        }
        return (int)returnedNumber;
    }

    public int getCurrentSequenceNumber() {
        return (int)this.sequenceNumber;
    }

    public void setServiceName(String who) {
        name = who;
    }

    public void setEnabled(boolean enable) {
    }

    public boolean stop() {
        if (this.state != 0) {
            if (this.sender != null) {
                this.sender.stopThread();
                this.sender = null;
            }
            if (this.receiver != null) {
                this.receiver.stopThread();
                this.receiver = null;
            }
            if (this.advertizer != null) {
                this.advertizer.stopThread();
                this.advertizer = null;
            }
            this.requestTable.stop();
            this.routingTable.stop();
            this.lp.deregisterProtocol((byte)103);
            this.state = 0;
        }
        return true;
    }

    public boolean start() {
        if (this.state != 2) {
            this.state = 1;
            if (!RoutingPolicyManager.getInstance().isEndNode()) {
                this.advertizer = new RoutingNeighbor(this.lp, this.ourAddress);
                this.advertizer.start();
            } else {
                this.advertizer = null;
            }
            this.requestTable = RequestTable.getInstance();
            this.requestTable.setOurAddress(this.ourAddress);
            this.requestTable.start();
            this.routingTable = RoutingTable.getInstance();
            this.routingTable.setOurAddress(this.ourAddress);
            this.routingTable.start();
            this.sender = new Sender(this.ourAddress, this.lp, this.mhRouteListeners);
            this.receiver = new Receiver(this.ourAddress, this.sender, this.lp, this.mhRouteListeners);
            RadioFactory.setAsDaemonThread((Thread)this.sender);
            RadioFactory.setAsDaemonThread((Thread)this.receiver);
            this.sender.start();
            this.receiver.start();
            this.state = 2;
        }
        return true;
    }

    public boolean resume() {
        return this.start();
    }

    public boolean pause() {
        return this.stop();
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public int getStatus() {
        return this.state;
    }

    public String getServiceName() {
        return name;
    }

    public boolean getEnabled() {
        return false;
    }
}

