/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv;

import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.mhrp.aodv.Sender;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.AODVMessage;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RERR;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREP;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestTable;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingTable;
import com.sun.spot.peripheral.radio.mhrp.interfaces.IMHEventListener;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingPolicyManager;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import com.sun.spot.util.Debug;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Queue;
import java.util.Enumeration;
import java.util.Vector;

public class Receiver
extends Thread
implements IProtocolManager {
    private RoutingTable routingTable = RoutingTable.getInstance();
    private RequestTable requestTable = RequestTable.getInstance();
    private static final int MAX_REQUESTS_OUTSTANDING = 500;
    private Sender sender;
    private boolean keepRunning = true;
    private Queue messageQueue;
    private Vector mhRouteListeners;
    private IRoutingPolicyManager rpm;
    private final long ourAddress;

    public Receiver(long ourAddress, Sender sender, ILowPan lowPan, Vector listeners) {
        super("AODVReceiver");
        this.sender = sender;
        this.ourAddress = ourAddress;
        this.messageQueue = new Queue();
        lowPan.registerProtocol((byte)103, this);
        this.mhRouteListeners = listeners;
        this.rpm = ((LowPan)lowPan).getRoutingPolicyManager();
    }

    public void run() {
        while (this.keepRunning) {
            ReceivedPacket receivedPacket = (ReceivedPacket)this.messageQueue.get();
            if (receivedPacket == null) continue;
            switch (receivedPacket.message.getType()) {
                case 1: {
                    this.handleRREQMessage((RREQ)receivedPacket.message, receivedPacket.messageSender);
                    break;
                }
                case 2: {
                    this.handleRREPMessage((RREP)receivedPacket.message, receivedPacket.messageSender);
                    break;
                }
                case 3: {
                    this.handleRERRMessage((RERR)receivedPacket.message, receivedPacket.messageSender);
                }
            }
        }
    }

    public void stopThread() {
        this.keepRunning = false;
        this.messageQueue.put(null);
    }

    private void handleRERRMessage(RERR message, long lastHop) {
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RERRReceived(message.getOrigAddress(), message.getDestAddress());
            }
        }
        this.routingTable.deactivateRoute(this.ourAddress, message.getDestAddress());
        if (message.getOrigAddress() != this.ourAddress) {
            this.routingTable.deactivateRoute(message.getOrigAddress(), message.getDestAddress());
            this.sender.forwardAODVMessage(message);
        }
    }

    private void handleRREPMessage(RREP message, long lastHop) {
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RREPReceived(message.getOrigAddress(), message.getDestAddress(), message.getHopCount());
            }
        }
        message.incrementHopCount();
        if (message.getOrigAddress() == 65535L) {
            RouteInfo ri = this.routingTable.getNextHopInfo(message.getDestAddress());
            if (ri.nextHop == -1L) {
                this.routingTable.addRoute(lastHop, message);
            }
            return;
        }
        if (message.getOrigAddress() == this.ourAddress) {
            this.routingTable.addRoute(lastHop, lastHop, 1, 1, 0);
            if (this.requestTable.hasActiveRequest(message)) {
                this.routingTable.addRoute(lastHop, message);
            }
            while (this.requestTable.hasActiveRequest(message)) {
                RouteEventClient client = this.requestTable.getCallback(message);
                if (client != null) {
                    Object uniqueKey = this.requestTable.removeOutstandingRequest(message.getDestAddress(), message.getOrigAddress());
                    RouteInfo info = new RouteInfo(message.getDestAddress(), lastHop, message.getHopCount());
                    client.routeFound(info, uniqueKey);
                    continue;
                }
                Debug.print("handleRREPMessage: null client asssociated Destination " + IEEEAddress.toDottedHex((long)message.getDestAddress()) + " Originator " + IEEEAddress.toDottedHex((long)message.getOrigAddress()), 1);
            }
        } else if (!this.rpm.isEndNode()) {
            this.routingTable.addRoute(lastHop, lastHop, 1, 1, 0);
            this.routingTable.addRoute(lastHop, message);
            this.sender.forwardAODVMessage(message);
        }
    }

    private void handleRREQMessage(RREQ message, long lastHop) {
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RREQReceived(message.getOrigAddress(), message.getDestAddress(), message.getHopCount());
            }
        }
        if (message.getOrigAddress() != this.ourAddress) {
            message.incrementHopCount();
            if (message.getHopCount() > 15) {
                return;
            }
            this.routingTable.addRoute(lastHop, lastHop, 1, 1, 0);
            this.routingTable.addRoute(lastHop, message);
            int currentSequenceNumber = this.routingTable.getDestinationSequenceNumber(message.getDestAddress());
            int receivedSequenceNumber = message.getDestSeqNum();
            if (currentSequenceNumber > receivedSequenceNumber) {
                message.setDestinationSequenceNumber(currentSequenceNumber);
            }
            if (message.getDestAddress() == this.ourAddress) {
                if (this.requestTable.hasActiveRequest(message)) {
                    RREP routeFoundMessage = new RREP(message);
                    this.sender.sendNewRREP(routeFoundMessage);
                }
            } else if (!this.rpm.isEndNode()) {
                this.sender.forwardAODVMessage(message);
            }
        }
    }

    public void processIncomingData(byte[] payload, LowPanHeaderInfo headerInfo) {
        byte AODVMessageType = payload[0];
        switch (AODVMessageType) {
            case 1: {
                RREQ rreqMessage = new RREQ(payload);
                if (this.requestTable.hasRequest(rreqMessage) || this.messageQueue.size() >= 500) break;
                this.requestTable.addRREQ(rreqMessage, null, null);
                this.messageQueue.put((Object)new ReceivedPacket(rreqMessage, headerInfo.sourceAddress));
                break;
            }
            case 2: {
                RREP rrepMessage = new RREP(payload);
                this.messageQueue.put((Object)new ReceivedPacket(rrepMessage, headerInfo.sourceAddress));
                break;
            }
            case 3: {
                RERR rerrMessage = new RERR(payload);
                this.messageQueue.put((Object)new ReceivedPacket(rerrMessage, headerInfo.sourceAddress));
                break;
            }
            default: {
                System.err.println("receiveData: bad packet from" + new IEEEAddress(headerInfo.sourceAddress).asDottedHex());
            }
        }
    }

    private class ReceivedPacket {
        public AODVMessage message;
        public long messageSender;

        public ReceivedPacket(AODVMessage message, long messageSender) {
            this.message = message;
            this.messageSender = messageSender;
        }
    }
}

