/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv;

import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.AODVMessage;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RERR;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREP;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestTable;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingTable;
import com.sun.spot.peripheral.radio.mhrp.interfaces.IMHEventListener;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import com.sun.spot.util.Queue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class Sender
extends Thread {
    private boolean keepRunning = true;
    private Queue outgoingAODVMessageQueue;
    private Queue routeWantedQueue;
    private Queue routeErrorQueue;
    private ILowPan lowPan;
    private RoutingTable routingTable;
    private RequestTable requestTable;
    private Vector mhRouteListeners;
    private Random randomGen;
    private final Object queueLock = new Integer(0);
    private static final int MAX_RETRIES = 3;
    private final long ourAddress;
    static /* synthetic */ Class class$com$sun$spot$peripheral$radio$mhrp$aodv$Sender;

    public Sender(long ourAddress, ILowPan lowPan, Vector listeners) {
        super("AODVSender");
        this.ourAddress = ourAddress;
        this.outgoingAODVMessageQueue = new Queue();
        this.routeWantedQueue = new Queue();
        this.routeErrorQueue = new Queue();
        this.lowPan = lowPan;
        this.mhRouteListeners = listeners;
        this.routingTable = RoutingTable.getInstance();
        this.requestTable = RequestTable.getInstance();
        this.randomGen = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.keepRunning) {
                Object object = this.queueLock;
                synchronized (object) {
                    if (this.outgoingAODVMessageQueue.isEmpty() && this.routeWantedQueue.isEmpty() && this.routeErrorQueue.isEmpty()) {
                        this.queueLock.wait();
                    }
                    block16: while (!this.outgoingAODVMessageQueue.isEmpty()) {
                        AODVMessage message = (AODVMessage)this.outgoingAODVMessageQueue.get();
                        try {
                            if (message == null) continue;
                            switch (message.getType()) {
                                case 1: {
                                    try {
                                        int r = this.randomGen.nextInt(50);
                                        Thread.sleep(r * 5);
                                    }
                                    catch (InterruptedException ie) {
                                        // empty catch block
                                    }
                                    this.sendRREQ((RREQ)message, null, null);
                                    continue block16;
                                }
                                case 2: {
                                    this.sendRREP((RREP)message);
                                    continue block16;
                                }
                                case 3: {
                                    this.sendRERR((RERR)message);
                                    continue block16;
                                }
                            }
                            System.err.println((class$com$sun$spot$peripheral$radio$mhrp$aodv$Sender == null ? Sender.class$("com.sun.spot.peripheral.radio.mhrp.aodv.Sender") : class$com$sun$spot$peripheral$radio$mhrp$aodv$Sender).getName() + ": unknown AODV message type");
                        }
                        catch (NoAckException e) {
                        }
                        catch (ChannelBusyException e) {}
                    }
                    while (!this.routeErrorQueue.isEmpty()) {
                        RouteErrorEntry routeError = (RouteErrorEntry)this.routeErrorQueue.get();
                        this.sendRERR(new RERR(routeError.originator, routeError.destination));
                    }
                    while (!this.routeWantedQueue.isEmpty()) {
                        RouteWantedEntry routeWanted = (RouteWantedEntry)this.routeWantedQueue.get();
                        this.sendRREQ(new RREQ(this.ourAddress, routeWanted.address), routeWanted.eventClient, routeWanted.uniqueKey);
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        this.keepRunning = false;
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendNewRREQ(long address, RouteEventClient eventClient, Object uniqueKey) {
        RouteWantedEntry entry = new RouteWantedEntry();
        entry.address = address;
        entry.eventClient = eventClient;
        entry.uniqueKey = uniqueKey;
        this.routeWantedQueue.put((Object)entry);
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendNewRERR(long originator, long destination) {
        RouteErrorEntry entry = new RouteErrorEntry();
        entry.originator = originator;
        entry.destination = destination;
        this.routeErrorQueue.put((Object)entry);
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendNewRREP(RREP message) {
        this.outgoingAODVMessageQueue.put((Object)message);
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forwardAODVMessage(AODVMessage message) {
        this.outgoingAODVMessageQueue.put((Object)message);
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        return true;
    }

    private void sendRREQ(RREQ message, RouteEventClient eventClient, Object uniqueKey) throws ChannelBusyException, NoAckException {
        byte[] buffer = message.writeMessage();
        if (!this.requestTable.hasRequest(message)) {
            this.requestTable.addRREQ(message, eventClient, uniqueKey);
        }
        this.lowPan.sendBroadcast((byte)103, buffer, 0, buffer.length, 0);
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RREQSent(message.getOrigAddress(), message.getDestAddress(), message.getHopCount());
            }
        }
    }

    private void sendRREP(RREP message) throws ChannelBusyException {
        byte[] buffer = message.writeMessage();
        long destinationAddress = this.routingTable.getNextHopInfo((long)message.getOrigAddress()).nextHop;
        if (destinationAddress != -1L) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.lowPan.sendWithoutMeshingOrFragmentation((byte)103, destinationAddress, buffer, 0, buffer.length);
                    break;
                }
                catch (NoAckException e) {
                    this.routingTable.deactivateRoute(message.getDestAddress(), message.getOrigAddress());
                    this.sendNewRERR(message.getDestAddress(), message.getOrigAddress());
                    continue;
                }
            }
        }
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RREPSent(message.getOrigAddress(), message.getDestAddress(), message.getHopCount());
            }
        }
    }

    private void sendRERR(RERR message) throws ChannelBusyException {
        byte[] buffer = message.writeMessage();
        long destinationAddress = this.routingTable.getNextHopInfo((long)message.getOrigAddress()).nextHop;
        if (destinationAddress != -1L) {
            try {
                this.lowPan.sendWithoutMeshingOrFragmentation((byte)103, destinationAddress, buffer, 0, buffer.length);
            }
            catch (NoAckException e) {
                this.routingTable.deactivateRoute(message.getDestAddress(), message.getOrigAddress());
            }
        }
        if (!this.mhRouteListeners.isEmpty()) {
            Enumeration en = this.mhRouteListeners.elements();
            while (en.hasMoreElements()) {
                ((IMHEventListener)en.nextElement()).RERRSent(message.getOrigAddress(), message.getDestAddress());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RouteErrorEntry {
        public long originator;
        public long destination;

        private RouteErrorEntry() {
        }
    }

    private class RouteWantedEntry {
        public long address;
        public RouteEventClient eventClient;
        public Object uniqueKey;

        private RouteWantedEntry() {
        }
    }
}

