/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv.messages;

import com.sun.spot.peripheral.radio.mhrp.aodv.AODVManager;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.AODVMessage;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestTable;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingTable;
import com.sun.spot.util.Utils;

public class RREQ
extends AODVMessage {
    private byte[] message;
    private int requestID;
    private short hopCount;
    private static AODVManager routingManager = AODVManager.getInstance();
    private static RoutingTable routingTable = RoutingTable.getInstance();
    static /* synthetic */ Class class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ;

    public RREQ(long origAddress, long destinationMACaddress) {
        this.type = 1;
        this.message = new byte[32];
        this.hopCount = 0;
        this.requestID = RequestTable.getNextRREQID();
        this.destAddress = destinationMACaddress;
        this.destSeqNum = routingTable.getDestinationSequenceNumber(destinationMACaddress);
        this.origAddress = origAddress;
        this.origSeqNum = routingManager.getNextSequenceNumber();
    }

    public RREQ(byte[] newMessage) {
        this.type = 1;
        this.message = newMessage;
        this.hopCount = this.message[3];
        this.requestID = Utils.readBigEndInt((byte[])this.message, (int)4);
        this.destAddress = Utils.readBigEndLong((byte[])this.message, (int)8);
        this.destSeqNum = Utils.readBigEndInt((byte[])this.message, (int)16);
        this.origAddress = Utils.readBigEndLong((byte[])this.message, (int)20);
        this.origSeqNum = Utils.readBigEndInt((byte[])this.message, (int)28);
    }

    public byte[] writeMessage() {
        this.message[0] = this.type;
        this.message[3] = (byte)(this.hopCount & 0xFF);
        Utils.writeBigEndInt((byte[])this.message, (int)4, (int)this.requestID);
        Utils.writeBigEndLong((byte[])this.message, (int)8, (long)this.destAddress);
        Utils.writeBigEndInt((byte[])this.message, (int)16, (int)this.destSeqNum);
        Utils.writeBigEndLong((byte[])this.message, (int)20, (long)this.origAddress);
        Utils.writeBigEndInt((byte[])this.message, (int)28, (int)this.origSeqNum);
        return this.message;
    }

    public boolean getDestinationOnlyFlag() {
        return (this.message[1] & 0x80) != 0;
    }

    public void setDestinationOnlyFlag(boolean flag) {
        this.message[1] = flag ? (byte)(this.message[1] | 0x80) : (byte)(this.message[1] & 0x7F);
    }

    public boolean getGratuitousRREPFlag() {
        return (this.message[1] & 0x40) != 0;
    }

    public void setGratuitousRREPFlag(boolean flag) {
        if (flag) {
            this.message[1] = (byte)(this.message[1] | 0x40);
        } else {
            this.message[2] = (byte)(this.message[2] & 0xBF);
        }
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public short getHopCount() {
        return this.hopCount;
    }

    public short incrementHopCount() {
        this.hopCount = (short)(this.hopCount + 1);
        return this.hopCount;
    }

    public short getRouteCost() {
        throw new IllegalStateException((class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ == null ? (class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ = RREQ.class$("com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ")) : class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ).getName() + ": method not implemented");
    }

    public short setRouteCost() {
        throw new IllegalStateException((class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ == null ? (class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ = RREQ.class$("com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ")) : class$com$sun$spot$peripheral$radio$mhrp$aodv$messages$RREQ).getName() + ": method not implemented");
    }

    public void setDestinationSequenceNumber(int destinationSequenceNumber) {
        this.destSeqNum = destinationSequenceNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

