/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv.request;

import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREP;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestEntry;
import com.sun.spot.peripheral.radio.mhrp.aodv.request.RequestTableCleaner;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.SortedList;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class RequestTable {
    private final Hashtable table;
    private final SortedList timeoutList;
    private static final Object RREQlock = new Integer(0);
    private static int currentRREQID;
    private long ourAddress;
    private Object cleanerMonitor;
    private static RequestTable instance;
    private RequestTableCleaner cleaner;

    private RequestTable() {
        Random rnd = new Random();
        this.timeoutList = new SortedList();
        this.table = new Hashtable();
        currentRREQID = rnd.nextInt(65535);
        this.cleanerMonitor = new Object();
    }

    public void start() {
        this.cleaner = new RequestTableCleaner(this);
        RadioFactory.setAsDaemonThread((Thread)this.cleaner);
        this.cleaner.start();
    }

    public void stop() {
        this.cleaner.stopThread();
    }

    public static synchronized RequestTable getInstance() {
        if (instance == null) {
            instance = new RequestTable();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextRREQID() {
        int returnVal;
        Object object = RREQlock;
        synchronized (object) {
            if (++currentRREQID == 65536) {
                currentRREQID = 1;
            }
            returnVal = currentRREQID;
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRREQ(RREQ message, RouteEventClient eventClient, Object uniqueKey) {
        Long wantedDestination = new Long(message.getDestAddress());
        RequestEntry entry = new RequestEntry();
        entry.activityFlag = true;
        entry.key = wantedDestination;
        entry.requestID = message.getRequestID();
        entry.expiryTime = System.currentTimeMillis() + 6900L;
        entry.originatorMACAddress = new Long(message.getOrigAddress());
        entry.client = eventClient;
        entry.uniqueKey = uniqueKey;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    this.timeoutList.insertElement(entry);
                    v.addElement(entry);
                } else {
                    Vector<Object> v = new Vector<Object>();
                    v.addElement(this.table.remove(wantedDestination));
                    v.addElement(entry);
                    this.timeoutList.insertElement(entry);
                    this.table.put(wantedDestination, v);
                }
            } else {
                this.timeoutList.insertElement(entry);
                this.table.put(wantedDestination, entry);
            }
        }
        this.notifyCleaner();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveRequest(RREQ message) {
        Long wantedDestination = new Long(message.getDestAddress());
        boolean returnVal = false;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress.longValue() != message.getOrigAddress() || entry.requestID != message.getRequestID()) continue;
                        returnVal = entry.activityFlag;
                        breakOut = true;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress.longValue() == message.getOrigAddress() && entry.requestID == message.getRequestID()) {
                        returnVal = entry.activityFlag;
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveRequest(RREP message) {
        Long wantedDestination = new Long(message.getDestAddress());
        boolean returnVal = false;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress.longValue() != message.getOrigAddress()) continue;
                        returnVal |= entry.activityFlag;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress.longValue() == message.getOrigAddress()) {
                        returnVal = entry.activityFlag;
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequest(RREQ message) {
        Long wantedDestination = new Long(message.getDestAddress());
        boolean returnVal = false;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress.longValue() != message.getOrigAddress() || entry.requestID != message.getRequestID()) continue;
                        returnVal = true;
                        breakOut = true;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress.longValue() == message.getOrigAddress() && entry.requestID == message.getRequestID()) {
                        returnVal = true;
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequest(RREP message) {
        Long wantedDestination = new Long(message.getDestAddress());
        boolean returnVal = false;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress.longValue() != message.getOrigAddress()) continue;
                        returnVal = true;
                        breakOut = true;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress.longValue() == message.getOrigAddress()) {
                        returnVal = true;
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeOutstandingRequest(long destination, long originator) {
        Long wantedDestination = new Long(destination);
        Object returnedKey = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress != originator) continue;
                        breakOut = true;
                        v.removeElement(entry);
                        this.timeoutList.removeElement(entry);
                        returnedKey = entry.uniqueKey;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress == originator) {
                        this.table.remove(wantedDestination);
                        this.timeoutList.removeElement(entry);
                        returnedKey = entry.uniqueKey;
                    }
                }
            }
        }
        return returnedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTable() {
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            long expiryCutoff = System.currentTimeMillis() + 5L;
            RequestEntry entry = (RequestEntry)this.timeoutList.getFirstElement();
            boolean elementsRemaining = true;
            while (entry != null && elementsRemaining) {
                if (entry.expiryTime < expiryCutoff) {
                    if (entry.activityFlag) {
                        this.timeoutList.removeFirstElement();
                        entry.activityFlag = false;
                        entry.expiryTime = System.currentTimeMillis() + 60000L;
                        this.timeoutList.insertElement(entry);
                        if (entry.originatorMACAddress - this.ourAddress == 0L && entry.client != null) {
                            RouteInfo info = new RouteInfo(entry.key, -1L, 0);
                            entry.client.routeFound(info, entry.uniqueKey);
                        }
                    } else {
                        this.timeoutList.removeFirstElement();
                        this.removeOutstandingRequest(entry.key, entry.originatorMACAddress);
                    }
                } else {
                    elementsRemaining = false;
                }
                entry = (RequestEntry)this.timeoutList.getFirstElement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteEventClient getCallback(RREP message) {
        Long wantedDestination = new Long(message.getDestAddress());
        RouteEventClient returnedClient = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object o = this.table.get(wantedDestination);
            if (o != null) {
                if (o instanceof Vector) {
                    Vector v = (Vector)o;
                    Enumeration e = v.elements();
                    boolean breakOut = false;
                    while (e.hasMoreElements() && !breakOut) {
                        RequestEntry entry = (RequestEntry)e.nextElement();
                        if (entry.originatorMACAddress.longValue() != message.getOrigAddress()) continue;
                        breakOut = true;
                        returnedClient = entry.client;
                    }
                } else {
                    RequestEntry entry = (RequestEntry)o;
                    if (entry.originatorMACAddress.longValue() == message.getOrigAddress()) {
                        returnedClient = entry.client;
                    }
                }
            }
        }
        return returnedClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCleaner() {
        Object object = this.cleanerMonitor;
        synchronized (object) {
            this.cleanerMonitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilTableNotEmpty() {
        while (this.timeoutList.getFirstElement() == null) {
            Object object = this.cleanerMonitor;
            synchronized (object) {
                try {
                    this.cleanerMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setOurAddress(long ourAddress) {
        this.ourAddress = ourAddress;
    }
}

