/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.mhrp.aodv.routing;

import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREP;
import com.sun.spot.peripheral.radio.mhrp.aodv.messages.RREQ;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingEntry;
import com.sun.spot.peripheral.radio.mhrp.aodv.routing.RoutingTableCleaner;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.SortedList;
import com.sun.spot.util.Debug;
import com.sun.spot.util.IEEEAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RoutingTable {
    private final Hashtable table;
    private final SortedList timeoutList = new SortedList();
    private Long ourAddress;
    private static RoutingTable instance;
    private RoutingTableCleaner cleaner;
    private Object cleanerMonitor;

    private RoutingTable() {
        this.table = new Hashtable();
        this.cleanerMonitor = new Object();
    }

    public void start() {
        this.cleaner = new RoutingTableCleaner(this);
        RadioFactory.setAsDaemonThread((Thread)this.cleaner);
        this.cleaner.start();
    }

    public void stop() {
        this.cleaner.stopThread();
    }

    public static synchronized RoutingTable getInstance() {
        if (instance == null) {
            instance = new RoutingTable();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteInfo getNextHopInfo(long address) {
        RoutingEntry returnedEntry;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            returnedEntry = (RoutingEntry)this.table.get(new Long(address));
        }
        if (returnedEntry != null && returnedEntry.activityFlag) {
            this.freshenRoute(address);
            return new RouteInfo(address, returnedEntry.nextHopMACAddress, returnedEntry.hopCount);
        }
        if (returnedEntry == null) {
            Debug.print("[AODV] no route found for: " + IEEEAddress.toDottedHex((long)address) + " at " + System.currentTimeMillis());
            return new RouteInfo(address, -1L, 0);
        }
        Debug.print("[AODV] reactivate inactive route found for: " + IEEEAddress.toDottedHex((long)address) + " through " + IEEEAddress.toDottedHex((long)returnedEntry.nextHopMACAddress) + " hops " + returnedEntry.hopCount + " at " + System.currentTimeMillis());
        this.freshenRoute(address);
        return new RouteInfo(address, returnedEntry.nextHopMACAddress, returnedEntry.hopCount);
    }

    public void addRoute(long address, long nextHopMACAddress, int hopCount, int routeCost, int destSeqNumber) {
        Debug.print("addRoute: adding route for " + IEEEAddress.toDottedHex((long)address) + " next hop " + IEEEAddress.toDottedHex((long)nextHopMACAddress) + " hops " + hopCount + " at " + System.currentTimeMillis());
        Long wantedAddress = new Long(address);
        RoutingEntry entry = new RoutingEntry();
        entry.key = wantedAddress;
        entry.nextHopMACAddress = new Long(nextHopMACAddress);
        entry.hopCount = hopCount;
        entry.routeCost = routeCost;
        entry.sequenceNumber = destSeqNumber;
        entry.activityFlag = true;
        this.doTableAddition(wantedAddress, entry);
    }

    public void addRoute(long senderMACAddress, RREQ message) {
        Long wantedOriginator = new Long(message.getOrigAddress());
        Debug.print("addRoute (RREQ): adding back route for " + IEEEAddress.toDottedHex((long)message.getOrigAddress()) + " asked about " + IEEEAddress.toDottedHex((long)message.getDestAddress()) + " heard from " + IEEEAddress.toDottedHex((long)senderMACAddress) + " hops " + message.getHopCount() + " at " + System.currentTimeMillis());
        if (!wantedOriginator.equals(this.ourAddress)) {
            RoutingEntry entry = new RoutingEntry();
            entry.key = new Long(message.getOrigAddress());
            entry.nextHopMACAddress = new Long(senderMACAddress);
            entry.hopCount = message.getHopCount();
            entry.sequenceNumber = message.getOrigSeqNum();
            entry.activityFlag = true;
            this.doTableAddition(wantedOriginator, entry);
        }
    }

    public void addRoute(long senderMACAddress, RREP message) {
        Long wantedDestination = new Long(message.getDestAddress());
        Debug.print("addRoute (RREP): adding route for " + IEEEAddress.toDottedHex((long)wantedDestination) + " through " + IEEEAddress.toDottedHex((long)senderMACAddress) + " hops " + message.getHopCount() + " at " + System.currentTimeMillis());
        RoutingEntry entry = new RoutingEntry();
        entry.key = wantedDestination;
        entry.nextHopMACAddress = new Long(senderMACAddress);
        entry.hopCount = message.getHopCount();
        entry.sequenceNumber = message.getDestSeqNum();
        entry.activityFlag = true;
        entry.routeUsers.addElement(new Long(message.getOrigAddress()));
        this.doTableAddition(wantedDestination, entry);
    }

    public int getDestinationSequenceNumber(long address) {
        Long wantedDestination = new Long(address);
        RoutingEntry entry = (RoutingEntry)this.table.get(wantedDestination);
        if (entry != null) {
            return entry.sequenceNumber;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cleanTable() {
        long result = 0L;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            long expiryCutoff = System.currentTimeMillis() + 5L;
            RoutingEntry entry = (RoutingEntry)this.timeoutList.getFirstElement();
            boolean entriesRemaining = true;
            while (entry != null && entriesRemaining) {
                if (entry.expiryTime < expiryCutoff) {
                    this.timeoutList.removeFirstElement();
                    if (entry.activityFlag) {
                        Debug.print("[AODV] cleaner clear flag for route to " + IEEEAddress.toDottedHex((long)entry.key) + " through " + IEEEAddress.toDottedHex((long)entry.nextHopMACAddress) + " at " + System.currentTimeMillis());
                        entry.activityFlag = false;
                        entry.expiryTime = System.currentTimeMillis() + 2500L;
                        this.timeoutList.insertElement(entry);
                    } else {
                        Debug.print("[AODV] cleaner remove entry route to   " + IEEEAddress.toDottedHex((long)entry.key) + " through " + IEEEAddress.toDottedHex((long)entry.nextHopMACAddress) + " at " + System.currentTimeMillis());
                        this.table.remove(entry.key);
                    }
                } else {
                    entriesRemaining = false;
                }
                entry = (RoutingEntry)this.timeoutList.getFirstElement();
            }
            if (entry != null) {
                result = entry.expiryTime - System.currentTimeMillis();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableAddition(Long key, RoutingEntry newEntry) {
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            newEntry.expiryTime = System.currentTimeMillis() + 30000L;
            RoutingEntry existingEntry = (RoutingEntry)this.table.get(key);
            if (existingEntry != null) {
                if (existingEntry.activityFlag) {
                    if (existingEntry.hopCount > newEntry.hopCount) {
                        this.timeoutList.insertElement(newEntry);
                        if (!existingEntry.routeUsers.isEmpty()) {
                            this.copyUserList(existingEntry.routeUsers, newEntry.routeUsers);
                        }
                        this.table.put(key, newEntry);
                        this.timeoutList.removeElement(existingEntry);
                    } else {
                        this.freshenRoute(key);
                        if (!newEntry.routeUsers.isEmpty()) {
                            Long user = (Long)newEntry.routeUsers.firstElement();
                            existingEntry.routeUsers.addElement(user);
                        }
                    }
                } else if (newEntry.nextHopMACAddress.equals(existingEntry.nextHopMACAddress)) {
                    this.timeoutList.removeElement(existingEntry);
                    existingEntry.activityFlag = true;
                    existingEntry.expiryTime = System.currentTimeMillis() + 30000L;
                    if (!newEntry.routeUsers.isEmpty()) {
                        Long user = (Long)newEntry.routeUsers.firstElement();
                        existingEntry.routeUsers.addElement(user);
                    }
                    this.timeoutList.insertElement(existingEntry);
                } else {
                    if (!existingEntry.routeUsers.isEmpty()) {
                        this.copyUserList(existingEntry.routeUsers, newEntry.routeUsers);
                    }
                    this.timeoutList.insertElement(newEntry);
                    this.table.put(key, newEntry);
                }
            } else {
                this.timeoutList.insertElement(newEntry);
                this.table.put(key, newEntry);
            }
        }
        this.notifyCleaner();
    }

    private void copyUserList(Vector oldList, Vector newList) {
        Enumeration oldRouteUsers = oldList.elements();
        while (oldRouteUsers.hasMoreElements()) {
            Long routeUser = (Long)oldRouteUsers.nextElement();
            newList.addElement(routeUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freshenRoute(long address) {
        Long wantedAddress = new Long(address);
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            RoutingEntry entry = (RoutingEntry)this.table.get(wantedAddress);
            if (entry == null) {
                Debug.print("[AODV] Attempt to freshen non-existant route to " + IEEEAddress.toDottedHex((long)address));
                return false;
            }
            this.timeoutList.removeElement(entry);
            entry.activityFlag = true;
            entry.expiryTime = System.currentTimeMillis() + 30000L;
            this.timeoutList.insertElement(entry);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateRoute(long originator, long destination) {
        Long wantedAddress = new Long(destination);
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            RoutingEntry entry = (RoutingEntry)this.table.get(wantedAddress);
            if (entry != null) {
                Debug.print("[AODV] deactivatingRoute (remove entry): " + IEEEAddress.toDottedHex((long)entry.key) + " through " + IEEEAddress.toDottedHex((long)entry.nextHopMACAddress) + " user " + IEEEAddress.toDottedHex((long)originator) + " at " + System.currentTimeMillis());
                this.timeoutList.removeElement(entry);
                this.table.remove(entry.key);
            } else {
                Debug.print("[AODV] attempt to deactivate missing route to " + destination + " at " + System.currentTimeMillis(), 1);
            }
        }
    }

    public Vector getAllEntries() {
        Vector v = new Vector();
        Enumeration en = this.table.elements();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCleaner() {
        Object object = this.cleanerMonitor;
        synchronized (object) {
            this.cleanerMonitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilTableNotEmpty() {
        while (this.timeoutList.getFirstElement() == null) {
            Object object = this.cleanerMonitor;
            synchronized (object) {
                try {
                    this.cleanerMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void dumpTable() {
        Vector v = this.getAllEntries();
        System.out.println("Dest\t\tNext Hop\t\tDist\tActive\tTimeout");
        for (int i = 0; i < v.size(); ++i) {
            RoutingEntry re = (RoutingEntry)v.elementAt(i);
            System.out.println(IEEEAddress.toDottedHex((long)re.key) + "\t" + IEEEAddress.toDottedHex((long)re.nextHopMACAddress) + "\t" + re.hopCount + "\t" + re.activityFlag + "\t" + re.expiryTime);
        }
    }

    public void setOurAddress(long ourAddress) {
        this.ourAddress = new Long(ourAddress);
    }
}

