/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.proxy;

import com.sun.spot.interisolate.BooleanReplyEnvelope;
import com.sun.spot.interisolate.NumberReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.RequestSender;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IRadioProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.proxy.AddInputConnectionCommand;
import com.sun.spot.peripheral.radio.proxy.AddOutputConnectionCommand;
import com.sun.spot.peripheral.radio.proxy.CloseConnectionCommand;
import com.sun.spot.peripheral.radio.proxy.PacketsAvailableCommand;
import com.sun.spot.peripheral.radio.proxy.ReceiveRadioPacketCommand;
import com.sun.spot.peripheral.radio.proxy.ReceiveRadioPacketWithTimeoutCommand;
import com.sun.spot.peripheral.radio.proxy.SendRadioPacketCommand;
import com.sun.squawk.io.mailboxes.NoSuchMailboxException;

public class ProxyRadioProtocolManager
implements IRadioProtocolManager {
    protected RequestSender requestSender;

    protected ProxyRadioProtocolManager(byte protocolNum, String name, String channelIdentifier) {
        try {
            this.requestSender = RequestSender.lookup((String)channelIdentifier);
        }
        catch (NoSuchMailboxException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void closeConnection(ConnectionID cid) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new CloseConnectionCommand(cid));
        resultEnvelope.checkForRuntimeException();
    }

    public ConnectionID addOutputConnection(long macAddress, byte portNo) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new AddOutputConnectionCommand(macAddress, portNo));
        resultEnvelope.checkForRuntimeException();
        return (ConnectionID)resultEnvelope.getContents();
    }

    public ConnectionID addInputConnection(long macAddress, byte portNo) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new AddInputConnectionCommand(macAddress, portNo));
        resultEnvelope.checkForRuntimeException();
        return (ConnectionID)resultEnvelope.getContents();
    }

    public long send(ConnectionID cid, long toAddress, byte[] payload, int length) throws NoAckException, ChannelBusyException, NoRouteException {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new SendRadioPacketCommand(cid, toAddress, payload, length));
        try {
            resultEnvelope.checkForThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NoAckException e) {
            throw e;
        }
        catch (ChannelBusyException e) {
            throw e;
        }
        catch (NoRouteException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SpotFatalException("Unexpected exception: " + e);
        }
        return ((NumberReplyEnvelope)resultEnvelope).getLongContents();
    }

    public IncomingData receivePacket(ConnectionID cid) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new ReceiveRadioPacketCommand(cid));
        resultEnvelope.checkForRuntimeException();
        return (IncomingData)resultEnvelope.getContents();
    }

    public IncomingData receivePacket(ConnectionID cid, long timeout) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new ReceiveRadioPacketWithTimeoutCommand(cid, timeout));
        resultEnvelope.checkForRuntimeException();
        return (IncomingData)resultEnvelope.getContents();
    }

    public boolean packetsAvailable(ConnectionID connectionID) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new PacketsAvailableCommand(connectionID));
        resultEnvelope.checkForRuntimeException();
        return ((BooleanReplyEnvelope)resultEnvelope).getBooleanContents();
    }
}

