/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.proxy;

import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IRadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.NoMeshLayerAckException;
import com.sun.spot.peripheral.radio.proxy.AddBroadcastConnectionCommand;
import com.sun.spot.peripheral.radio.proxy.AddServerConnectionCommand;
import com.sun.spot.peripheral.radio.proxy.ProxyRadioProtocolManager;
import com.sun.spot.peripheral.radio.proxy.WaitForAllAcksCommand;

public class ProxyRadiostreamProtocolManager
extends ProxyRadioProtocolManager
implements IRadiostreamProtocolManager {
    public static final String CHANNEL_IDENTIFIER = "RADIOSTREAM_SERVER";

    public ProxyRadiostreamProtocolManager(byte protocolNum, String name) {
        super(protocolNum, name, CHANNEL_IDENTIFIER);
    }

    public void waitForAllAcks(ConnectionID outConnectionId) throws NoAckException, ChannelBusyException, NoMeshLayerAckException, NoRouteException {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new WaitForAllAcksCommand(outConnectionId));
        try {
            resultEnvelope.checkForThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NoAckException e) {
            throw e;
        }
        catch (ChannelBusyException e) {
            throw e;
        }
        catch (NoMeshLayerAckException e) {
            throw e;
        }
        catch (NoRouteException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SpotFatalException("Unexpected exception: " + e);
        }
    }

    public ConnectionID addServerConnection(byte portNo) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new AddServerConnectionCommand(portNo));
        resultEnvelope.checkForRuntimeException();
        return (ConnectionID)resultEnvelope.getContents();
    }

    public ConnectionID addBroadcastConnection(byte portNo) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new AddBroadcastConnectionCommand(portNo));
        resultEnvelope.checkForRuntimeException();
        return (ConnectionID)resultEnvelope.getContents();
    }
}

