/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.routing;

import com.sun.spot.peripheral.Spot;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.routing.RoutingPolicy;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingPolicyManager;
import com.sun.spot.util.Debug;

public class RoutingPolicyManager
implements IRoutingPolicyManager {
    private static RoutingPolicyManager rpm;
    private static final String ROUTING_POLICY_PROPERTY = "spot.mesh.routing.enable";
    private static RoutingPolicy defaultPolicy;
    private static boolean oldSleepMode;
    private RoutingPolicy active = new RoutingPolicy(0);

    private RoutingPolicyManager() {
        if (!RadioFactory.isRunningOnHost()) {
            oldSleepMode = RadioFactory.getSleepManager().isDeepSleepEnabled();
        }
        RoutingPolicy startup = defaultPolicy;
        Debug.print("[RoutingPolicyManager] Starting Routing Policy Manager");
        String mode = System.getProperty(ROUTING_POLICY_PROPERTY);
        if (mode == null || "true".equalsIgnoreCase(mode)) {
            startup = defaultPolicy;
        }
        if ("endnode".equalsIgnoreCase(mode) || "false".equalsIgnoreCase(mode)) {
            startup = new RoutingPolicy(1);
        }
        if ("always".equalsIgnoreCase(mode)) {
            startup = new RoutingPolicy(2);
        }
        if ("ifawake".equalsIgnoreCase(mode)) {
            startup = new RoutingPolicy(3);
        }
        this.policyHasChanged(startup);
    }

    public static synchronized IRoutingPolicyManager getInstance() {
        if (rpm == null) {
            rpm = new RoutingPolicyManager();
        }
        return rpm;
    }

    public void policyHasChanged(RoutingPolicy newPolicy) {
        if (this.active.equals(newPolicy)) {
            return;
        }
        this.active = newPolicy;
        Debug.print("[rpm] Routing policy now: " + this.toString());
        if (!RadioFactory.isRunningOnHost()) {
            if (this.routeAlways()) {
                oldSleepMode = RadioFactory.getSleepManager().isDeepSleepEnabled();
                Spot.getInstance().getSleepManager().disableDeepSleep();
            } else {
                Spot.getInstance().getSleepManager().enableDeepSleep(oldSleepMode);
            }
            Debug.print("[rpm] Old Sleep policy: " + oldSleepMode);
            Debug.print("[rpm] New Sleep policy: " + Spot.getInstance().getSleepManager().isDeepSleepEnabled());
        }
    }

    public String toString() {
        return this.active.toString();
    }

    public boolean maySleep() {
        return !this.active.equals(2) && !this.active.equals(4);
    }

    public boolean routeAlways() {
        return this.active.equals(2) || this.active.equals(4);
    }

    public boolean isEndNode() {
        return this.active.equals(1);
    }

    public boolean bridgeBroadcasts() {
        return this.active.equals(4);
    }

    static {
        defaultPolicy = new RoutingPolicy(3);
    }
}

