/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio.shrp;

import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.mhrp.interfaces.IMHEventListener;
import com.sun.spot.peripheral.radio.routing.RouteInfo;
import com.sun.spot.peripheral.radio.routing.RouteTable;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingManager;
import com.sun.spot.peripheral.radio.routing.interfaces.RouteEventClient;
import java.util.Enumeration;
import java.util.Hashtable;

public class SingleHopManager
implements IRoutingManager {
    private int state;
    private static String name = "SingleHopManager";
    private static long ourAddress;
    private static ILowPan lowpan;
    private Hashtable routes = new Hashtable();
    private Hashtable invalidRoutes = new Hashtable();
    private static final int MAX_FAILURES = 3;

    public RouteTable getRoutingTable() {
        RouteTable rt = new RouteTable();
        Enumeration en = this.routes.elements();
        while (en.hasMoreElements()) {
            rt.addEntry((RouteInfo)en.nextElement());
        }
        return rt;
    }

    public synchronized boolean findRoute(long address, RouteEventClient eventClient, Object uniqueKey) {
        Integer fails = (Integer)this.invalidRoutes.get(new Long(address));
        RouteInfo info = (RouteInfo)this.routes.get(new Long(address));
        if (fails != null && fails >= 3) {
            info = new RouteInfo(address, -1L, 0);
            this.invalidRoutes.remove(new Long(address));
            eventClient.routeFound(info, uniqueKey);
            return true;
        }
        if (info == null) {
            info = new RouteInfo(address, address, 1);
            this.routes.put(new Long(address), info);
        }
        eventClient.routeFound(info, uniqueKey);
        return true;
    }

    public void registerEventListener(IMHEventListener listener) {
    }

    public void deregisterEventListener(IMHEventListener listener) {
    }

    public synchronized boolean invalidateRoute(long originator, long destination) {
        Long key = new Long(destination);
        this.routes.remove(key);
        Integer val = (Integer)this.invalidRoutes.get(key);
        if (val == null) {
            this.invalidRoutes.put(key, new Integer(1));
        } else {
            this.invalidRoutes.put(key, new Integer(val + 1));
        }
        return true;
    }

    public synchronized void initialize(long ourAddress, ILowPan lowPanLayer) {
        SingleHopManager.ourAddress = ourAddress;
        lowpan = lowPanLayer;
    }

    public synchronized RouteInfo getRouteInfo(long address) {
        RouteInfo info = (RouteInfo)this.routes.get(new Long(address));
        if (info == null) {
            info = new RouteInfo(address, address, 1);
            this.routes.put(new Long(address), info);
        }
        return info;
    }

    public void setServiceName(String who) {
        name = who;
    }

    public void setEnabled(boolean enable) {
    }

    public boolean stop() {
        this.state = 0;
        return true;
    }

    public boolean start() {
        this.state = 2;
        return true;
    }

    public boolean resume() {
        return this.start();
    }

    public boolean pause() {
        return this.stop();
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public int getStatus() {
        return this.state;
    }

    public String getServiceName() {
        return name;
    }

    public boolean getEnabled() {
        return false;
    }
}

