/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.radiostream;

import com.sun.spot.io.j2me.radiostream.RadioInputStream;
import com.sun.spot.io.j2me.radiostream.RadioOutputStream;
import com.sun.spot.io.j2me.radiostream.RadiostreamConnection;
import com.sun.spot.peripheral.RadioConnectionBase;
import com.sun.spot.peripheral.radio.ConnectionID;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.IRadiostreamProtocolManager;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPolicy;
import com.sun.spot.peripheral.radio.RadiostreamProtocolManager;
import com.sun.spot.util.IEEEAddress;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;

public class Protocol
extends RadioConnectionBase
implements RadiostreamConnection {
    private long macAddress;
    private byte portNo;
    private RadioPolicy selection = RadioPolicy.ON;
    private RadioInputStream radioInputStream;
    private RadioOutputStream radioOutputStream;
    private static IRadiostreamProtocolManager protocolManager;
    private static IRadioPolicyManager radioPolicyManager;

    private static synchronized IRadiostreamProtocolManager getProtocolManager() {
        if (protocolManager == null) {
            protocolManager = RadiostreamProtocolManager.getInstance();
        }
        return protocolManager;
    }

    public static void setProtocolManager(IRadiostreamProtocolManager protocolManager) {
        Protocol.protocolManager = protocolManager;
    }

    private static synchronized IRadioPolicyManager getRadioPolicyManager() {
        if (radioPolicyManager == null) {
            radioPolicyManager = RadioFactory.getRadioPolicyManager();
        }
        return radioPolicyManager;
    }

    public static void setRadioPolicyManager(IRadioPolicyManager manager) {
        radioPolicyManager = manager;
    }

    public Connection open(String protocolName, String name, int mode, boolean timeouts) {
        int portNoAsInt = 0;
        int split = (name = name.substring(2)).indexOf(":");
        if (split >= 0 && split != name.length() - 1) {
            portNoAsInt = Integer.parseInt(name.substring(split + 1));
            if (portNoAsInt <= 0 || portNoAsInt > 255) {
                throw new IllegalArgumentException("Cannot open " + name + ". Port number is invalid");
            }
        } else {
            split = split < 0 ? name.length() : name.length() - 1;
        }
        this.macAddress = new IEEEAddress(name.substring(0, split)).asLong();
        this.portNo = (byte)portNoAsInt;
        if (timeouts) {
            this.setTimeout(10000L);
        }
        return this;
    }

    public InputStream openInputStream() {
        ConnectionID inputConnectionID = Protocol.getProtocolManager().addInputConnection(this.macAddress, this.portNo);
        this.radioInputStream = new RadioInputStream(Protocol.getProtocolManager(), inputConnectionID, this.getTimeout(), this.selection, Protocol.getRadioPolicyManager());
        this.portNo = inputConnectionID.getPortNo();
        return this.radioInputStream;
    }

    public OutputStream openOutputStream() {
        ConnectionID outputConnectionID = Protocol.getProtocolManager().addOutputConnection(this.macAddress, this.portNo);
        this.radioOutputStream = new RadioOutputStream(Protocol.getProtocolManager(), outputConnectionID, this.selection, Protocol.getRadioPolicyManager());
        this.portNo = outputConnectionID.getPortNo();
        return this.radioOutputStream;
    }

    public void setRadioPolicy(RadioPolicy selection) {
        this.selection = selection;
        if (this.radioInputStream != null) {
            this.radioInputStream.setRadioPolicy(selection);
        }
        if (this.radioOutputStream != null) {
            this.radioOutputStream.setRadioPolicy(selection);
        }
    }

    public byte getLocalPort() {
        if (this.portNo == 0) {
            throw new IllegalStateException("Radiostream connection has no port assigned before streams opened.");
        }
        return this.portNo;
    }

    public void setTimeout(long time) {
        super.setTimeout(time);
        if (this.radioInputStream != null) {
            this.radioInputStream.setTimeout(time);
        }
    }
}

