/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.jdwpforwarder;

import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpHandshakeParser;
import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpPacketParser;
import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpProtocolParser;
import java.io.IOException;
import java.io.OutputStream;

final class JdwpOutputStream
extends OutputStream {
    private static final byte[] DISPOSE_COMMAND = new byte[]{0, 0, 0, 11, -1, -1, -54, -2, 0, 1, 6};
    private final OutputStream innerStream;
    private JdwpProtocolParser jdwpProtocolParser;

    public JdwpOutputStream(OutputStream outputStream) {
        this.innerStream = outputStream;
        this.jdwpProtocolParser = JdwpOutputStream.createJdwpProtocolParser();
    }

    @Override
    public void write(int n) throws IOException {
        this.innerStream.write(n);
        this.jdwpProtocolParser = this.jdwpProtocolParser.update(n & 0xFF);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.innerStream.write(byArray, n, n2);
        for (int i = n; i < n2; ++i) {
            this.jdwpProtocolParser = this.jdwpProtocolParser.update(byArray[i] & 0xFF);
        }
    }

    @Override
    public void flush() throws IOException {
        this.innerStream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
            if (this.jdwpProtocolParser.isInitialized() && !this.jdwpProtocolParser.isDisposed() && !this.jdwpProtocolParser.isBroken()) {
                System.out.println("Sending dispose command to the VM.");
                this.innerStream.write(DISPOSE_COMMAND);
                this.innerStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.innerStream.close();
    }

    private static JdwpProtocolParser createJdwpProtocolParser() {
        JdwpPacketParser jdwpPacketParser = new JdwpPacketParser();
        JdwpHandshakeParser jdwpHandshakeParser = new JdwpHandshakeParser(jdwpPacketParser);
        return jdwpHandshakeParser;
    }
}

