/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.jdwpforwarder;

import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpProtocolParser;
import com.sun.jme.toolkit.socket.jdwpforwarder.JdwpTerminalParser;

final class JdwpPacketParser
implements JdwpProtocolParser {
    private static final int VM_COMMAND_SET = 1;
    private static final int DISPOSE_COMMAND = 6;
    private int offset;
    private int length;
    private boolean isCommand;
    private int commandSet;
    private int command;

    JdwpPacketParser() {
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public boolean isBroken() {
        return false;
    }

    @Override
    public JdwpProtocolParser update(int n) {
        if (this.offset < 4) {
            this.length = this.length << 8 | n;
            ++this.offset;
            return this;
        }
        if (this.offset > this.length) {
            return JdwpTerminalParser.getInstance(false, true);
        }
        switch (this.offset) {
            case 8: {
                this.isCommand = n == 0;
                break;
            }
            case 9: {
                this.commandSet = n;
                break;
            }
            case 10: {
                this.command = n;
            }
        }
        if (++this.offset == this.length) {
            if (this.isCommand && this.commandSet == 1 && this.command == 6) {
                return JdwpTerminalParser.getInstance(true, false);
            }
            this.offset = 0;
            this.length = 0;
        }
        return this;
    }
}

