/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.tray.items.ui;

import com.sun.jme.toolkit.devicedetection.api.AutomaticDeviceTypeDetector;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressListener;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AddressDialog
extends JDialog {
    private static final String IP_ADDRESS_REGEX = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
    private final DeviceAddressManager addressManager;
    private final AutomaticDeviceTypeDetector typeDetector;
    private JButton addButton;
    private JTextField addField;
    private JList addressList;
    private JScrollPane addressListPane;
    private JPanel buttonPanel;
    private JPanel centralPanel;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JButton okButton;
    private JButton removeButton;
    private JPanel sidePanel;

    public AddressDialog(DeviceAddressManager deviceAddressManager, AutomaticDeviceTypeDetector automaticDeviceTypeDetector) {
        super((Frame)null);
        this.addressManager = deviceAddressManager;
        this.typeDetector = automaticDeviceTypeDetector;
        this.initComponents();
        this.addressList.setModel(new AddressListModel());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.mainPanel = new JPanel();
        this.addField = new JTextField();
        this.addButton = new JButton();
        this.sidePanel = new JPanel();
        this.removeButton = new JButton();
        this.centralPanel = new JPanel();
        this.addressListPane = new JScrollPane();
        this.addressList = new JList();
        this.jLabel1 = new JLabel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.setTitle("Device Address Manager");
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 16, 0, 0);
        this.mainPanel.add((Component)this.addField, gridBagConstraints);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressDialog.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mainPanel.add((Component)this.addButton, gridBagConstraints);
        this.sidePanel.setLayout(new BoxLayout(this.sidePanel, 3));
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressDialog.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.sidePanel.add(this.removeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.mainPanel.add((Component)this.sidePanel, gridBagConstraints);
        this.centralPanel.setBorder(BorderFactory.createTitledBorder("IP Addresses"));
        this.centralPanel.setLayout(new BorderLayout());
        this.addressListPane.setBorder(null);
        this.addressList.setSelectionMode(0);
        this.addressListPane.setViewportView(this.addressList);
        this.centralPanel.add((Component)this.addressListPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.mainPanel.add((Component)this.centralPanel, gridBagConstraints);
        this.jLabel1.setText("<html><body>Devices are automatically detected on following IPs.</body></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 0, 10);
        this.mainPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.getContentPane().add(this.mainPanel);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add(this.buttonPanel);
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        try {
            int n;
            DeviceIpAddress deviceIpAddress = new DeviceIpAddress(this.addField.getText());
            if (!this.addField.getText().matches(IP_ADDRESS_REGEX)) {
                throw new UnknownHostException();
            }
            InetAddress inetAddress = InetAddress.getByName(this.addField.getText());
            boolean bl = false;
            try {
                bl = !inetAddress.isReachable(1000);
            }
            catch (IOException iOException) {
                bl = true;
            }
            if (bl && (n = JOptionPane.showConfirmDialog(null, "There doesn't seems to be a device running on the specified address.\n Are you sure you want to add this IP to the list?", "No device detected", 0)) == 1) {
                return;
            }
            this.addressManager.addDeviceAddress((DeviceAddress)deviceIpAddress);
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(null, "IP address is incorrect!", "Address error", 0);
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        for (Object object : objectArray = this.addressList.getSelectedValues()) {
            this.addressManager.removeDeviceAddress((DeviceAddress)object);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private class AddressListModel
    implements ListModel {
        private List<DeviceAddress> addresses = new ArrayList<DeviceAddress>();
        private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AddressListModel() {
            DeviceAddressManager deviceAddressManager = AddressDialog.this.addressManager;
            synchronized (deviceAddressManager) {
                this.addresses = new ArrayList<DeviceAddress>(Arrays.asList(AddressDialog.this.addressManager.getDeviceAddresses()));
                AddressDialog.this.addressManager.addDeviceAddressListener(new DeviceAddressListener(){

                    public void deviceAddressAdded(DeviceAddress deviceAddress, int n) {
                        int n2 = AddressListModel.this.addresses.indexOf(deviceAddress);
                        if (n2 == -1) {
                            AddressListModel.this.addresses.add(deviceAddress);
                            for (ListDataListener listDataListener : AddressListModel.this.listeners) {
                                listDataListener.intervalAdded(new ListDataEvent(AddressListModel.this, 1, AddressListModel.this.addresses.size() - 1, AddressListModel.this.addresses.size() - 1));
                            }
                        } else {
                            for (ListDataListener listDataListener : AddressListModel.this.listeners) {
                                listDataListener.contentsChanged(new ListDataEvent(AddressListModel.this, 0, n2, n2));
                            }
                        }
                    }

                    public void deviceAddressRemoved(DeviceAddress deviceAddress, int n) {
                        int n2 = AddressListModel.this.addresses.indexOf(deviceAddress);
                        if (n == 0) {
                            for (ListDataListener listDataListener : AddressListModel.this.listeners) {
                                AddressListModel.this.addresses.remove(n2);
                                listDataListener.intervalRemoved(new ListDataEvent(AddressListModel.this, 2, n2, n2));
                            }
                        } else {
                            for (ListDataListener listDataListener : AddressListModel.this.listeners) {
                                listDataListener.contentsChanged(new ListDataEvent(AddressListModel.this, 0, n2, n2));
                            }
                        }
                    }
                });
            }
        }

        @Override
        public int getSize() {
            return this.addresses.size();
        }

        public Object getElementAt(int n) {
            DeviceAddress deviceAddress = this.addresses.get(n);
            return deviceAddress;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }
    }
}

