/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.tray.items.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class OutputFrame
extends JFrame {
    private OutputFrameAppender appender = new OutputFrameAppender();
    private boolean scrollDownBlock = false;
    private JTextField findField;
    private JTable table;
    private JScrollPane tableScrollPane;

    public OutputFrameAppender getAppender() {
        return this.appender;
    }

    public OutputFrame() {
        this.initComponents();
        this.findField.setVisible(false);
        this.tableScrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JScrollBar jScrollBar = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                synchronized (jScrollBar) {
                    OutputFrame.this.scrollDownBlock = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JScrollBar jScrollBar = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                synchronized (jScrollBar) {
                    JScrollBar jScrollBar2 = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                    if (jScrollBar2.getValue() >= jScrollBar2.getMaximum() - jScrollBar2.getVisibleAmount()) {
                        OutputFrame.this.scrollDownBlock = false;
                    }
                }
            }
        });
        this.tableScrollPane.addMouseWheelListener(new MouseWheelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                JScrollBar jScrollBar = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                synchronized (jScrollBar) {
                    JScrollBar jScrollBar2 = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                    OutputFrame.this.scrollDownBlock = jScrollBar2.getValue() < jScrollBar2.getMaximum() - jScrollBar2.getVisibleAmount();
                }
            }
        });
        this.table.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JScrollBar jScrollBar = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                synchronized (jScrollBar) {
                    if (OutputFrame.this.scrollDownBlock) {
                        return;
                    }
                    JScrollBar jScrollBar2 = OutputFrame.this.tableScrollPane.getVerticalScrollBar();
                    jScrollBar2.setValue(jScrollBar2.getMaximum() - jScrollBar2.getVisibleAmount());
                }
            }
        });
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.findField = new JTextField();
        this.tableScrollPane.setPreferredSize(new Dimension(900, 700));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Logger", "Level", "Message"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.table.setColumnSelectionAllowed(true);
        this.tableScrollPane.setViewportView(this.table);
        this.table.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setMinWidth(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setMaxWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(500);
        this.getContentPane().add((Component)this.tableScrollPane, "Center");
        this.getContentPane().add((Component)this.findField, "Last");
        this.pack();
    }

    private class OutputFrameAppender
    implements Appender {
        private Filter filterChain;
        private Filter lastFilter;
        private String appenderName = OutputFrameAppender.class.getSimpleName();

        private OutputFrameAppender() {
        }

        public void addFilter(Filter filter) {
            if (this.filterChain == null) {
                this.lastFilter = this.filterChain = filter;
            } else {
                this.lastFilter.setNext(filter);
                this.lastFilter = filter;
            }
        }

        public Filter getFilter() {
            return this.filterChain;
        }

        public void clearFilters() {
            this.lastFilter = null;
            this.filterChain = null;
        }

        public void close() {
        }

        public void doAppend(LoggingEvent loggingEvent) {
            if (this.filterChain != null && this.filterChain.decide(loggingEvent) == -1) {
                return;
            }
            ((DefaultTableModel)OutputFrame.this.table.getModel()).addRow(new Object[]{loggingEvent.getLoggerName(), loggingEvent.getLevel().toString(), loggingEvent.getRenderedMessage()});
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public void setLayout(Layout layout) {
        }

        public Layout getLayout() {
            return null;
        }

        public boolean requiresLayout() {
            return false;
        }

        public String getName() {
            return this.appenderName;
        }

        public void setName(String string) {
            this.appenderName = string;
        }
    }
}

