/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.client.rmiimpl;

import com.sun.jme.toolkit.remoting.client.api.CallbackRegistration;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackNotification;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackServer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class CallbackClient
implements NotificationListener {
    private static final Logger LOGGER = Logger.getLogger(CallbackClient.class);
    public static NotificationFilter FILTER = new CallbackNotificationFilter();
    private final CallbackServer remoteServerObject;
    private Map<String, List<CallbackEntry>> listenerRegistry = new HashMap<String, List<CallbackEntry>>();
    private final MBeanServerConnection mBeanConnection;
    private final ObjectName remoteServerName;

    public CallbackClient(MBeanServerConnection mBeanServerConnection, ObjectName objectName, CallbackServer callbackServer) {
        this.mBeanConnection = mBeanServerConnection;
        this.remoteServerName = objectName;
        this.remoteServerObject = callbackServer;
    }

    void start() throws Exception {
        this.registerNotifications();
    }

    synchronized void stop() {
        this.unregisterNotifications();
        this.unregisterCallbacks();
    }

    private void registerNotifications() throws InstanceNotFoundException, IOException {
        this.mBeanConnection.addNotificationListener(this.remoteServerName, this, FILTER, null);
    }

    private void unregisterNotifications() {
        try {
            this.mBeanConnection.removeNotificationListener(this.remoteServerName, this, FILTER, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <ListenerType> void registerCallback(String string, Class<ListenerType> clazz, ListenerType ListenerType, CallbackRegistration callbackRegistration) throws Exception {
        CallbackEntry callbackEntry = this.createCallbackEntry(string, ListenerType);
        callbackEntry.id = this.remoteServerObject.registerCallback(string, clazz, callbackRegistration);
    }

    public void unRegisterCallback(String string, Object object) throws Exception {
        CallbackEntry callbackEntry = this.removeCallbackEntry(string, object);
        if (callbackEntry != null) {
            this.remoteServerObject.unregisterCallback(callbackEntry.id);
        }
    }

    private void unregisterCallbacks() {
        while (this.listenerRegistry.keySet().size() > 0) {
            String string = this.listenerRegistry.keySet().iterator().next();
            List<CallbackEntry> list = this.listenerRegistry.remove(string);
            for (CallbackEntry callbackEntry : list) {
                try {
                    this.remoteServerObject.unregisterCallback(callbackEntry.id);
                }
                catch (Exception exception) {}
            }
        }
    }

    private synchronized CallbackEntry createCallbackEntry(String string, Object object) {
        if (this.listenerRegistry.get(string) == null) {
            this.listenerRegistry.put(string, new ArrayList());
        }
        CallbackEntry callbackEntry = new CallbackEntry();
        callbackEntry.listener = object;
        callbackEntry.remoteObjectName = string;
        this.listenerRegistry.get(string).add(callbackEntry);
        return callbackEntry;
    }

    private synchronized CallbackEntry removeCallbackEntry(String string, Object object) {
        if (this.listenerRegistry.get(string) != null) {
            Iterator<CallbackEntry> iterator = this.listenerRegistry.get(string).iterator();
            while (iterator.hasNext()) {
                CallbackEntry callbackEntry = iterator.next();
                if (!callbackEntry.listener.equals(object)) continue;
                iterator.remove();
                return callbackEntry;
            }
        }
        return null;
    }

    private synchronized CallbackEntry removeCallbackEntry(String string, long l) {
        if (this.listenerRegistry.get(string) != null) {
            Iterator<CallbackEntry> iterator = this.listenerRegistry.get(string).iterator();
            while (iterator.hasNext()) {
                CallbackEntry callbackEntry = iterator.next();
                if (callbackEntry.id != l) continue;
                iterator.remove();
                return callbackEntry;
            }
        }
        return null;
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object object) {
        LOGGER.debug((Object)("Handling notification " + notification));
        CallbackNotification callbackNotification = (CallbackNotification)notification;
        List<CallbackEntry> list = this.listenerRegistry.get(callbackNotification.getRemoteObjectName());
        if (list == null || list.size() == 0) {
            return;
        }
        for (CallbackEntry callbackEntry : list) {
            if (callbackEntry.id != callbackNotification.getCallbackId()) continue;
            try {
                this.invokeMethod(callbackEntry.listener, callbackNotification.getMethodCalled(), callbackNotification.getMethodParams(), callbackNotification.getArgsPassed());
                return;
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Failed to invoke callback: object=" + callbackEntry.listener + " method=" + callbackNotification.getMethodCalled() + " parameter types: " + callbackNotification.getMethodParams().length));
                this.disfunctionalCallback(callbackNotification);
                System.err.println("Failed to invoke callback:");
                exception.printStackTrace();
            }
        }
    }

    private void disfunctionalCallback(CallbackNotification callbackNotification) {
        this.removeCallbackEntry(callbackNotification.getRemoteObjectName(), callbackNotification.getCallbackId());
        try {
            this.remoteServerObject.unregisterCallback(callbackNotification.getCallbackId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = object.getClass().getMethod(string, classArray);
        method.invoke(object, objectArray);
    }

    static class CallbackEntry {
        long id;
        String remoteObjectName;
        Object listener;

        CallbackEntry() {
        }
    }

    static class CallbackNotificationFilter
    implements NotificationFilter {
        CallbackNotificationFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            boolean bl = notification instanceof CallbackNotification;
            LOGGER.debug((Object)("isNotificationEnabled " + notification + " returns " + bl));
            return bl;
        }
    }
}

