/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.client.rmiimpl;

import com.sun.jme.toolkit.remoting.client.api.CallbackRegistration;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnectionListener;
import com.sun.jme.toolkit.remoting.client.rmiimpl.CallbackClient;
import com.sun.jme.toolkit.remoting.client.rmiimpl.CallbackRegistrationByReflection;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class ObjectServerConnectionImpl
implements ObjectServerConnection,
NotificationListener {
    private static final Logger LOGGER = Logger.getLogger(ObjectServerConnectionImpl.class);
    private transient JMXConnector jmxc;
    private transient MBeanServerConnection connection;
    private String host;
    private int rmiPort;
    private String name;
    private String domain;
    private CallbackClient callbackClient;
    private List<ObjectServerConnectionListener> connectionListeners = new ArrayList<ObjectServerConnectionListener>();
    private int connectionAttemptCount;
    private long connectionAttemptDelay;

    public void setConnectionAttemptCount(int n) {
        this.connectionAttemptCount = n;
    }

    public void setConnectionAttemptDelay(long l) {
        this.connectionAttemptDelay = l;
    }

    public void setRmiRegistryHost(String string) {
        this.host = string;
    }

    public void setRmiRegistryPort(int n) {
        this.rmiPort = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void start() throws Exception {
        if (this.connection == null) {
            block7: {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
                hashMap.put("java.naming.provider.url", "rmi://" + this.host + ":" + this.rmiPort);
                String string = "service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.rmiPort + "/" + this.name;
                try {
                    this.jmxc = this.connect(hashMap, string);
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)("Remote object server is not running at " + string));
                    for (ObjectServerConnectionListener objectServerConnectionListener : this.connectionListeners) {
                        objectServerConnectionListener.openFailed();
                    }
                    for (int i = 0; i < this.connectionAttemptCount; ++i) {
                        Thread.sleep(this.connectionAttemptDelay);
                        try {
                            this.jmxc = this.connect(hashMap, string);
                            break;
                        }
                        catch (IOException iOException2) {
                            continue;
                        }
                    }
                    if (this.jmxc != null) break block7;
                    throw iOException;
                }
            }
            this.jmxc.addConnectionNotificationListener(this, null, null);
            this.connection = this.jmxc.getMBeanServerConnection();
            this.domain = this.connection.getDefaultDomain();
            this.callbackClient = new CallbackClient(this.connection, this.objectName("CallbackServer"), this.findObject(CallbackServer.class, "CallbackServer"));
            this.callbackClient.start();
        }
    }

    private JMXConnector connect(Map map, String string) throws IOException {
        LOGGER.info((Object)("Connecting to " + string));
        return JMXConnectorFactory.connect(new JMXServiceURL(string), map);
    }

    public void stop() throws Exception {
        if (this.callbackClient == null) {
            return;
        }
        this.callbackClient.stop();
        this.callbackClient = null;
        this.connection = null;
        this.jmxc.removeConnectionNotificationListener(this);
        this.jmxc.close();
        this.jmxc = null;
    }

    public boolean isAlive() {
        return this.callbackClient != null;
    }

    public void addConnectionListener(ObjectServerConnectionListener objectServerConnectionListener) {
        LOGGER.debug((Object)("addConnectionListener " + objectServerConnectionListener));
        this.connectionListeners.add(objectServerConnectionListener);
    }

    public void removeConnectionListener(ObjectServerConnectionListener objectServerConnectionListener) {
        LOGGER.debug((Object)("removeConnectionListener " + objectServerConnectionListener));
        this.connectionListeners.remove(objectServerConnectionListener);
    }

    public <ListenerType> void registerCallback(String string, Class<ListenerType> clazz, ListenerType ListenerType, CallbackRegistration callbackRegistration) throws Exception {
        this.callbackClient.registerCallback(string, clazz, ListenerType, callbackRegistration);
    }

    public <ListenerType> void registerCallback(String string, Class<ListenerType> clazz, ListenerType ListenerType, String string2, String string3) throws Exception {
        this.callbackClient.registerCallback(string, clazz, ListenerType, new CallbackRegistrationByReflection(string2, string3));
    }

    public void unregisterCallback(String string, Object object) throws Exception {
        this.callbackClient.unRegisterCallback(string, object);
    }

    public <T> T findObject(Class<T> clazz, String string) throws Exception {
        return this.lookupMBean(clazz, this.objectName(string));
    }

    <T> T lookupMBean(Class<T> clazz, ObjectName objectName) throws Exception {
        if (this.connection == null) {
            this.start();
        }
        if (!this.connection.isRegistered(objectName)) {
            return null;
        }
        return clazz.cast(MBeanServerInvocationHandler.newProxyInstance(this.connection, objectName, clazz, false));
    }

    private ObjectName objectName(String string) throws MalformedObjectNameException {
        return ObjectName.getInstance(this.domain + ":object=" + string);
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        LOGGER.info((Object)("Notification: " + notification));
        JMXConnectionNotification jMXConnectionNotification = (JMXConnectionNotification)notification;
        if (jMXConnectionNotification.getType().equals("jmx.remote.connection.closed") || jMXConnectionNotification.getType().equals("jmx.remote.connection.failed")) {
            LOGGER.warn((Object)"Connection lost!");
            LOGGER.debug((Object)"Notifying listeners");
            for (ObjectServerConnectionListener objectServerConnectionListener : this.connectionListeners) {
                LOGGER.debug((Object)("Notifying listener " + objectServerConnectionListener));
                objectServerConnectionListener.connectionLost();
            }
            try {
                this.stop();
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
            }
        }
    }
}

