/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.cldc;

import com.sun.jme.emulator.cldc.SocketLocator;
import com.sun.jme.emulator.generic.AbstractArgumentParser;
import com.sun.jme.toolkit.environment.WorkdirHelper;
import com.sun.jme.toolkit.util.propstrparser.PropStringParser;
import com.sun.jme.toolkit.vm.ProcessLauncher;
import java.util.ArrayList;
import kdp.KDP;
import org.apache.log4j.Logger;

public class ArgumentsParser
extends AbstractArgumentParser {
    private static final Logger LOGGER = Logger.getLogger(ArgumentsParser.class);
    private int deviceId;
    private int stdoutPortNumber = -1;
    private int stderrPortNumber = -1;
    private int jdwpPortNumber = -1;
    private ProcessLauncher launcher;
    private KDP debugProxy;
    private static final int DEFAULT_DEBUGGER_PORT = 2800;
    private static final int DEFAULT_JDWP_PORT = 5086;
    private WorkdirHelper workdirHelper;

    public void setLauncher(ProcessLauncher processLauncher) {
        this.launcher = processLauncher;
    }

    public void setDebugProxy(KDP kDP) {
        this.debugProxy = kDP;
    }

    public void setWorkdirHelper(WorkdirHelper workdirHelper) {
        this.workdirHelper = workdirHelper;
    }

    public void processArguments(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i] == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Processing argument " + stringArray[i]));
            }
            if (stringArray[i].equals("-Xdevice") || stringArray[i].startsWith("-Xdevice:")) continue;
            if (stringArray[i].startsWith("-Xdeviceid:")) {
                string = stringArray[i].substring("-Xdeviceid:".length()).trim();
                this.deviceId = Integer.parseInt(string);
                continue;
            }
            if (stringArray[i].equals("-stdoutport")) {
                if (i + 1 >= stringArray.length) continue;
                this.stdoutPortNumber = ArgumentsParser.parseInt(stringArray[++i], -1);
                arrayList.add("-stdoutport");
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-stderrport")) {
                if (i + 1 >= stringArray.length) continue;
                this.stderrPortNumber = ArgumentsParser.parseInt(stringArray[++i], -1);
                arrayList.add("-stderrport");
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-XrunKDP:")) {
                string = stringArray[i].substring("-XrunKDP:".length());
                PropStringParser propStringParser = PropStringParser.createInstance((String)string);
                this.jdwpPortNumber = propStringParser.getIntValue("port", 5086);
                int n = new SocketLocator().findFreePort(2800);
                this.debugProxy.setKvmHost("127.0.0.1");
                this.debugProxy.setJdwpPort(this.jdwpPortNumber);
                this.debugProxy.setKdwpPort(n);
                arrayList.add("-debugger");
                arrayList.add("-port");
                arrayList.add(Integer.toString(n));
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        if (this.debugProxy != null) {
            this.debugProxy.setWorkdir(this.workdirHelper.deviceWorkDirectory(Integer.toString(this.deviceId)).getAbsolutePath());
        }
        this.launcher.appendArguments(arrayList);
        this.launcher.prependArgument("--");
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getStdoutPortNumber() {
        return this.stdoutPortNumber;
    }

    public int getStderrPortNumber() {
        return this.stderrPortNumber;
    }

    public int getJdwpPortNumber() {
        return this.jdwpPortNumber;
    }

    public boolean isMinimized() {
        return false;
    }

    public StringBuffer getAppName() {
        return new StringBuffer("CLDC HI-Prototype");
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

